// codec_pass.cpp
//
// Passthrough Codec
//
//   (C) Copyright 2016 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <stdio.h>
#include <unistd.h>

#include "codec_pass.h"

CodecPassthrough::CodecPassthrough(unsigned bitrate,QObject *parent)
  : Codec(Codec::TypePassthrough,bitrate,parent)
{
}


CodecPassthrough::~CodecPassthrough()
{
}


bool CodecPassthrough::isAvailable() const
{
  return true;
}


QString CodecPassthrough::defaultExtension() const
{
  return QString("wav");
}


void CodecPassthrough::process(const QByteArray &data,bool is_last)
{
  if(!isFramed()) {
    setFramed(channels(),samplerate(),
    	      channels()*samplerate()*sizeof(float)/1000);
  }
  writePcm((float *)data.constData(),data.length()/(channels()*sizeof(float)),
	   is_last);
}


void CodecPassthrough::loadStats(QStringList *hdrs,QStringList *values,
				 bool is_first)
{
}
