// rdtty.cpp
//
// Abstract a Rivendell TTY.
//
//   (C) Copyright 2002-2003 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdtty.cpp,v 1.5 2007/02/14 21:48:41 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <rconf.h>

#include <rdtty.h>


//
// Global Classes
//
RDTty::RDTty(QString station,unsigned port_id,bool create)
{
  QSqlQuery *q;
  QString sql;

  tty_station=station;
  tty_id=port_id;

  if(create) {
    sql=QString().sprintf("select ID from TTYS where \
(STATION_NAME=\"%s\")&&(PORT_ID=%d)",(const char *)tty_station,tty_id);
    q=new QSqlQuery(sql);
    if(q->size()!=1) {
      delete q;
      sql=QString().sprintf("INSERT INTO TTYS SET STATION_NAME=\"%s\",PORT_ID=%d",
			    (const char *)tty_station,tty_id);
      q=new QSqlQuery(sql);
      delete q;
    }
    else {
      delete q;
    }
  }
}


QString RDTty::station() const
{
  return tty_station;
}


int RDTty::portId() const
{
  return tty_id;
}


bool RDTty::active()
{
  return GetBoolValue("ACTIVE");
}


void RDTty::setActive(bool state)
{
  SetRow("ACTIVE",state);
}


QString RDTty::port()
{
  return GetStringValue("PORT");
}


void RDTty::setPort(QString port)
{
  SetRow("PORT",port);
}


int RDTty::baudRate()
{
  return GetIntValue("BAUD_RATE");
}


void RDTty::setBaudRate(int rate)
{
  SetRow("BAUD_RATE",rate);
}


int RDTty::dataBits()
{
  return GetIntValue("DATA_BITS");
}


void RDTty::setDataBits(int bits)
{
  SetRow("DATA_BITS",bits);
}


int RDTty::stopBits()
{
  return GetIntValue("STOP_BITS");
}


void RDTty::setStopBits(int bits)
{
  SetRow("STOP_BITS",bits);
}


RTTYDevice::Parity RDTty::parity()
{
  return (RTTYDevice::Parity)GetIntValue("PARITY");
}


void RDTty::setParity(RTTYDevice::Parity parity)
{
  SetRow("PARITY",(int)parity);
}


RDTty::Termination RDTty::termination()
{
  return (RDTty::Termination)GetIntValue("TERMINATION");
}


void RDTty::setTermination(RDTty::Termination term)
{
  SetRow("TERMINATION",(int)term);
}


bool RDTty::GetBoolValue(QString field)
{
  QString sql;
  QSqlQuery *q;
  bool state;

  sql=QString().sprintf("select %s from TTYS where \
(STATION_NAME=\"%s\")&&(PORT_ID=%d)",(const char *)field,
			(const char *)tty_station,tty_id);
  q=new QSqlQuery(sql);
  if(q->first()) {
    state=RBool(q->value(0).toString());
    delete q;
    return state;
  }
  delete q;
  return false;    
}


QString RDTty::GetStringValue(QString field)
{
  QString sql;
  QSqlQuery *q;
  QString accum;

  sql=QString().sprintf("select %s from TTYS where \
(STATION_NAME=\"%s\")&&(PORT_ID=%d)",(const char *)field,
			(const char *)tty_station,tty_id);
  q=new QSqlQuery(sql);
  if(q->first()) {
    accum=q->value(0).toString();
    delete q;
    return accum; 
  }
  delete q;
  return QString();    
}


int RDTty::GetIntValue(QString field)
{
  QString sql;
  QSqlQuery *q;
  int accum;

  sql=QString().sprintf("select %s from TTYS where \
(STATION_NAME=\"%s\")&&(PORT_ID=%d)",(const char *)field,
			(const char *)tty_station,tty_id);
  q=new QSqlQuery(sql);
  if(q->first()) {
    accum=q->value(0).toInt();
    delete q;
    return accum;
  }
  delete q;
  return 0;    
}


void RDTty::SetRow(QString param,bool value)
{
  QSqlQuery *q;
  QString sql;

  sql=QString().sprintf("UPDATE TTYS SET %s=\"%s\" \
WHERE (STATION_NAME=\"%s\")&&(PORT_ID=%d)",
			(const char *)param,
			(const char *)RYesNo(value),
			(const char *)tty_station,
			tty_id);
  q=new QSqlQuery(sql);
  delete q;
}


void RDTty::SetRow(QString param,QString value)
{
  QSqlQuery *q;
  QString sql;

  sql=QString().sprintf("UPDATE TTYS SET %s=\"%s\" \
WHERE (STATION_NAME=\"%s\")&&(PORT_ID=%d)",
			(const char *)param,
			(const char *)value,
			(const char *)tty_station,
			tty_id);
  q=new QSqlQuery(sql);
  delete q;
}


void RDTty::SetRow(QString param,int value)
{
  QSqlQuery *q;
  QString sql;

  sql=QString().sprintf("UPDATE TTYS SET %s=%d \
WHERE (STATION_NAME=\"%s\")&&(PORT_ID=%d)",
			(const char *)param,
			value,
			(const char *)tty_station,
			tty_id);
  q=new QSqlQuery(sql);
  delete q;
}


