// edit_matrix.cpp
//
// Edit a Rivendell Matrix
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: edit_matrix.cpp,v 1.22 2007/02/14 21:51:02 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qdialog.h>
#include <qstring.h>
#include <qtextedit.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include <qsqldatabase.h>
#include <rconf.h>
#include <math.h>

#include <rd.h>
#include <rdmatrix.h>
#include <rdtextvalidator.h>

#include <edit_user.h>
#include <edit_matrix.h>
#include <list_endpoints.h>
#include <list_gpis.h>
#include <list_vguest_resources.h>


EditMatrix::EditMatrix(RDMatrix *matrix,QWidget *parent,const char *name)
  : QDialog(parent,name,true)
{
  QString str;

  edit_matrix=matrix;

  //
  // Fix the Window Size
  //
  setMinimumWidth(sizeHint().width());
  setMaximumWidth(sizeHint().width());
  setMinimumHeight(sizeHint().height());
  setMaximumHeight(sizeHint().height());

  setCaption(tr("Edit Switcher"));

  //
  // Create Fonts
  //
  QFont bold_font=QFont("Helvetica",12,QFont::Bold);
  bold_font.setPixelSize(12);
  QFont font=QFont("Helvetica",12,QFont::Normal);
  font.setPixelSize(12);

  //
  // Text Validator
  //
  RDTextValidator *validator=new RDTextValidator(this,"validator");

  //
  // Matrix Number
  //
  QLabel *label=new QLabel(QString().sprintf("%d",edit_matrix->matrix()),
			   this,"edit_matrix_number");
  label->setGeometry(135,10,30,19);
  label->setFont(font);
  label=new QLabel(tr("Matrix Number:"),this,"matrix_label");
  label->setGeometry(10,10,120,19);
  label->setFont(bold_font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Matrix Type
  //
  label=new QLabel(edit_matrix->typeString(),this,"edit_type");
  label->setGeometry(135,30,200,19);
  label->setFont(font);
  label=new QLabel(tr("Switcher Type:"),this,"matrix_label");
  label->setGeometry(10,30,120,19);
  label->setFont(bold_font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Descriptive Name
  //
  edit_name_edit=new QLineEdit(this,"edit_name_edit");
  edit_name_edit->setGeometry(135,50,240,19);
  edit_name_edit->setValidator(validator);
  label=new QLabel(edit_name_edit,tr("Description:"),this,"edit_name_label");
  label->setGeometry(10,50,120,19);
  label->setFont(bold_font);
  label->setAlignment(AlignRight|AlignVCenter);

  //
  // Port Connection Type
  //
  edit_porttype_box=new QComboBox(this,"edit_porttype_edit");
  edit_porttype_box->setGeometry(135,72,120,19);
  edit_porttype_label=new QLabel(edit_porttype_box,tr("Connection Type:"),
				 this,"edit_porttype_label");
  edit_porttype_label->setGeometry(10,72,120,19);
  edit_porttype_label->setFont(bold_font);
  edit_porttype_label->setAlignment(AlignRight|AlignVCenter);
  edit_porttype_box->insertItem(tr("Serial"));
  edit_porttype_box->insertItem(tr("TCP/IP"));
  connect(edit_porttype_box,SIGNAL(activated(int)),
	  this,SLOT(portTypeActivatedData(int)));

  //
  // Card Number
  //
  edit_card_box=new QSpinBox(this,"edit_card_box");
  edit_card_box->setGeometry(325,72,50,19);
  edit_card_box->setRange(0,RD_MAX_CARDS-1);
  edit_card_label=
    new QLabel(edit_card_box,tr("Card:"),this,"edit_card_label");
  edit_card_label->setGeometry(280,72,40,19);
  edit_card_label->setFont(bold_font);
  edit_card_label->setAlignment(AlignRight|AlignVCenter);

  //
  // IP Address
  //
  edit_ipaddress_edit=new QLineEdit(this,"edit_ipaddress_edit");
  edit_ipaddress_edit->setGeometry(110,105,120,19);
  edit_ipaddress_label=new QLabel(edit_ipaddress_edit,tr("IP Address:"),
				  this,"edit_name_label");
  edit_ipaddress_label->setGeometry(25,105,80,19);
  edit_ipaddress_label->setFont(bold_font);
  edit_ipaddress_label->setAlignment(AlignRight|AlignVCenter);

  //
  // IP Port
  //
  edit_ipport_spin=new QSpinBox(this,"edit_ipport_spin");
  edit_ipport_spin->setGeometry(305,105,65,19);
  edit_ipport_spin->setRange(0,0xFFFF);
  edit_ipport_label=
    new QLabel(edit_ipport_spin,tr("IP Port:"),this,"edit_ipport_label");
  edit_ipport_label->setGeometry(240,105,60,19);
  edit_ipport_label->setFont(bold_font);
  edit_ipport_label->setAlignment(AlignRight|AlignVCenter);

  //
  // Username
  //
  edit_username_edit=new QLineEdit(this,"edit_username_edit");
  edit_username_edit->setGeometry(90,130,115,19);
  edit_username_label=new QLabel(edit_username_edit,tr("Username:"),
				  this,"edit_name_label");
  edit_username_label->setGeometry(10,130,75,19);
  edit_username_label->setFont(bold_font);
  edit_username_label->setAlignment(AlignRight|AlignVCenter);

  //
  // Password
  //
  edit_password_edit=new QLineEdit(this,"edit_password_edit");
  edit_password_edit->setGeometry(295,130,115,19);
  edit_password_edit->setEchoMode(QLineEdit::Password);
  edit_password_label=new QLabel(edit_password_edit,tr("Password:"),
				  this,"edit_name_label");
  edit_password_label->setGeometry(215,130,75,19);
  edit_password_label->setFont(bold_font);
  edit_password_label->setAlignment(AlignRight|AlignVCenter);

  //
  // Port
  //
  edit_port_box=new QComboBox(this,"edit_port_box");
  edit_port_box->setGeometry(75,155,90,19);
  edit_port_box->setEditable(false);
  edit_port_label=new QLabel(edit_port_box,tr("Port:"),this,"edit_name_label");
  edit_port_label->setGeometry(10,155,60,19);
  edit_port_label->setFont(bold_font);
  edit_port_label->setAlignment(AlignRight|AlignVCenter);

  //
  // Inputs
  //
  edit_inputs_box=new QSpinBox(this,"edit_inputs_box");
  edit_inputs_box->setGeometry(230,155,50,19);
  edit_inputs_box->setRange(0,MAX_ENDPOINTS);
  edit_inputs_label=
    new QLabel(edit_inputs_box,tr("Inputs:"),this,"edit_inputs_label");
  edit_inputs_label->setGeometry(175,155,50,19);
  edit_inputs_label->setFont(bold_font);
  edit_inputs_label->setAlignment(AlignRight|AlignVCenter);

  //
  // Outputs
  //
  edit_outputs_box=new QSpinBox(this,"edit_outputs_box");
  edit_outputs_box->setGeometry(355,155,50,19);
  edit_outputs_box->setRange(0,MAX_ENDPOINTS);
  edit_outputs_label=
    new QLabel(edit_outputs_box,tr("Outputs:"),this,"edit_outputs_label");
  edit_outputs_label->setGeometry(280,155,70,19);
  edit_outputs_label->setFont(bold_font);
  edit_outputs_label->setAlignment(AlignRight|AlignVCenter);

  //
  // Device
  //
  edit_device_edit=new QLineEdit(this,"edit_device_edit");
  edit_device_edit->setGeometry(75,180,90,19);
  edit_device_edit->setValidator(validator);
  edit_device_label=new QLabel(edit_device_edit,tr("Device:"),
			       this,"edit_name_label");
  edit_device_label->setGeometry(5,180,65,19);
  edit_device_label->setFont(bold_font);
  edit_device_label->setAlignment(AlignRight|AlignVCenter);

  //
  // GPIs
  //
  edit_gpis_box=new QSpinBox(this,"edit_gpis_box");
  edit_gpis_box->setGeometry(230,180,50,19);
  edit_gpis_box->setRange(0,MAX_GPIO_PINS);
  edit_gpis_label=
    new QLabel(edit_gpis_box,tr("GPIs:"),this,"edit_gpis_label");
  edit_gpis_label->setGeometry(175,180,50,19);
  edit_gpis_label->setFont(bold_font);
  edit_gpis_label->setAlignment(AlignRight|AlignVCenter);
  connect(edit_gpis_box,SIGNAL(valueChanged(int)),
	  this,SLOT(gpisChangedData(int)));

  //
  // GPOs
  //
  edit_gpos_box=new QSpinBox(this,"edit_gpos_box");
  edit_gpos_box->setGeometry(355,180,50,19);
  edit_gpos_box->setRange(0,MAX_GPIO_PINS);
  edit_gpos_label=
    new QLabel(edit_gpos_box,tr("GPOs:"),this,"edit_gpos_label");
  edit_gpos_label->setGeometry(280,180,70,19);
  edit_gpos_label->setFont(bold_font);
  edit_gpos_label->setAlignment(AlignRight|AlignVCenter);
  connect(edit_gpos_box,SIGNAL(valueChanged(int)),
	  this,SLOT(gposChangedData(int)));

  //
  // Displays
  //
  edit_displays_box=new QSpinBox(this,"edit_displays_box");
  edit_displays_box->setGeometry(355,205,50,19);
  edit_displays_box->setRange(0,1024);
  edit_displays_label=
    new QLabel(edit_displays_box,tr("Displays:"),this,"edit_displays_label");
  edit_displays_label->setGeometry(280,205,70,19);
  edit_displays_label->setFont(bold_font);
  edit_displays_label->setAlignment(AlignRight|AlignVCenter);

  //
  //  Configure Inputs Button
  //
  edit_inputs_button=new QPushButton(this,"inputs_button");
  edit_inputs_button->setGeometry(35,230,80,50);
  edit_inputs_button->setFont(bold_font);
  edit_inputs_button->setText(tr("Configure\n&Inputs"));
  connect(edit_inputs_button,SIGNAL(clicked()),this,SLOT(inputsButtonData()));

  //
  //  Configure Outputs Button
  //
  edit_outputs_button=new QPushButton(this,"outputs_button");
  edit_outputs_button->setGeometry(125,230,80,50);
  edit_outputs_button->setFont(bold_font);
  edit_outputs_button->setText(tr("Configure\n&Outputs"));
  connect(edit_outputs_button,SIGNAL(clicked()),
	  this,SLOT(outputsButtonData()));

  //
  //  Configure Crosspoints Button
  //
  edit_xpoint_button=new QPushButton(this,"xpoints_button");
  edit_xpoint_button->setGeometry(215,230,80,50);
  edit_xpoint_button->setDefault(true);
  edit_xpoint_button->setFont(bold_font);
  edit_xpoint_button->setText(tr("Configure\n&Xpoints"));
  connect(edit_xpoint_button,SIGNAL(clicked()),this,SLOT(xpointsButtonData()));

  //
  //  Configure GPIs Button
  //
  edit_gpis_button=new QPushButton(this,"edit_gpis_button");
  edit_gpis_button->setGeometry(305,230,80,50);
  edit_gpis_button->setDefault(true);
  edit_gpis_button->setFont(bold_font);
  edit_gpis_button->setText(tr("Configure\nGP&Is"));
  connect(edit_gpis_button,SIGNAL(clicked()),this,SLOT(gpisButtonData()));

  //
  //  vGuest switches Button
  //
  edit_vguestrelays_button=new QPushButton(this,"vguestrelays_button");
  edit_vguestrelays_button->setGeometry(125,290,80,50);
  edit_vguestrelays_button->setFont(bold_font);
  edit_vguestrelays_button->setText(tr("vGuest\nSwitches"));
  connect(edit_vguestrelays_button,SIGNAL(clicked()),
	  this,SLOT(vguestRelaysButtonData()));

  //
  //  vGuest Displays Button
  //
  edit_vguestdisplays_button=new QPushButton(this,"vguestdisplays_button");
  edit_vguestdisplays_button->setGeometry(215,290,80,50);
  edit_vguestdisplays_button->setFont(bold_font);
  edit_vguestdisplays_button->setText(tr("vGuest\nDisplays"));
  connect(edit_vguestdisplays_button,SIGNAL(clicked()),
	  this,SLOT(vguestDisplaysButtonData()));

  //
  //  Ok Button
  //
  QPushButton *button=new QPushButton(this,"ok_button");
  button->setGeometry(sizeHint().width()-180,sizeHint().height()-60,80,50);
  button->setDefault(true);
  button->setFont(bold_font);
  button->setText(tr("&OK"));
  connect(button,SIGNAL(clicked()),this,SLOT(okData()));

  //
  //  Cancel Button
  //
  button=new QPushButton(this,"cancel_button");
  button->setGeometry(sizeHint().width()-90,sizeHint().height()-60,
			     80,50);
  button->setFont(bold_font);
  button->setText(tr("&Cancel"));
  connect(button,SIGNAL(clicked()),this,SLOT(cancelData()));

  //
  // Load Values
  //
  edit_name_edit->setText(edit_matrix->name());
  str=QString(tr("Serial"));
  for(int i=0;i<MAX_TTYS;i++) {
    edit_port_box->insertItem(QString().sprintf("%s%d",(const char *)str,i));
  }
  edit_porttype_box->setCurrentItem((int)edit_matrix->portType());
  switch((RDMatrix::PortType)edit_porttype_box->currentItem()) {
      case RDMatrix::TtyPort:
	edit_port_box->setCurrentItem(edit_matrix->port());
	break;

      case RDMatrix::TcpPort:
	edit_ipaddress_edit->setText(edit_matrix->ipAddress().toString());
	edit_ipport_spin->setValue(edit_matrix->ipPort());
	break;
  }
  edit_card_box->setValue(edit_matrix->card());
  edit_inputs_box->setValue(edit_matrix->inputs());
  edit_outputs_box->setValue(edit_matrix->outputs());
  edit_device_edit->setText(edit_matrix->gpioDevice());
  edit_gpis_box->setValue(edit_matrix->gpis());
  edit_gpos_box->setValue(edit_matrix->gpos());
  edit_username_edit->setText(edit_matrix->username());
  edit_password_edit->setText(edit_matrix->password());
  edit_displays_box->setValue(edit_matrix->displays());
  switch(edit_matrix->type()) {
      case RDMatrix::LocalGpio:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_port_label->setDisabled(true);
	edit_port_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_inputs_button->setDisabled(true);
	edit_outputs_button->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	if(edit_gpis_box->value()==0) {
	  edit_gpis_button->setDisabled(true);
	}
	edit_inputs_label->setDisabled(true);
	edit_inputs_box->setDisabled(true);
	edit_outputs_label->setDisabled(true);
	edit_outputs_box->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::GenericGpo:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_port_label->setDisabled(true);
	edit_port_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::GenericSerial:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::Unity4000:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_outputs_box->setRange(0,4);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::Sas32000:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::Sas64000:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::BtSs82:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_inputs_label->setDisabled(true);
	edit_inputs_box->setDisabled(true);
	edit_outputs_label->setDisabled(true);
	edit_outputs_box->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::Bt10x1:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_inputs_label->setDisabled(true);
	edit_inputs_box->setDisabled(true);
	edit_outputs_label->setDisabled(true);
	edit_outputs_box->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::Sas64000Gpi:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	if(edit_gpis_box->value()==0) {
	  edit_gpis_button->setDisabled(true);
	}
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::Bt16x1:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_inputs_label->setDisabled(true);
	edit_inputs_box->setDisabled(true);
	edit_outputs_label->setDisabled(true);
	edit_outputs_box->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::Bt8x2:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_inputs_label->setDisabled(true);
	edit_inputs_box->setDisabled(true);
	edit_outputs_label->setDisabled(true);
	edit_outputs_box->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::BtAcs82:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::SasUsi:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_port_box->setDisabled(true);
	edit_porttype_label->setEnabled(true);
	edit_porttype_box->setEnabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::Bt16x2:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::BtSs124:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_inputs_label->setDisabled(true);
	edit_inputs_box->setDisabled(true);
	edit_outputs_label->setDisabled(true);
	edit_outputs_box->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::LocalAudioAdapter:
	edit_port_label->setDisabled(true);
	edit_port_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::LogitekVguest:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_port_box->setDisabled(true);
	edit_porttype_label->setEnabled(true);
	edit_porttype_box->setEnabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_username_label->setEnabled(true);
	edit_username_edit->setEnabled(true);
	edit_password_label->setEnabled(true);
	edit_password_edit->setEnabled(true);
	edit_displays_label->setEnabled(true);
	edit_displays_box->setEnabled(true);
	edit_vguestrelays_button->setEnabled(true);
	edit_vguestdisplays_button->setEnabled(true);
	break;

      case RDMatrix::BtSs164:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_inputs_label->setDisabled(true);
	edit_inputs_box->setDisabled(true);
	edit_outputs_label->setDisabled(true);
	edit_outputs_box->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::StarGuideIII:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_outputs_box->setRange(0,6);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      case RDMatrix::BtSs42:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_inputs_label->setDisabled(true);
	edit_inputs_box->setDisabled(true);
	edit_outputs_label->setDisabled(true);
	edit_outputs_box->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;

      default:
	edit_card_label->setDisabled(true);
	edit_card_box->setDisabled(true);
	edit_porttype_label->setDisabled(true);
	edit_porttype_box->setDisabled(true);
	edit_device_label->setDisabled(true);
	edit_device_edit->setDisabled(true);
	edit_xpoint_button->setDisabled(true);
	edit_gpis_button->setDisabled(true);
	edit_inputs_label->setDisabled(true);
	edit_inputs_box->setDisabled(true);
	edit_outputs_label->setDisabled(true);
	edit_outputs_box->setDisabled(true);
	edit_gpis_label->setDisabled(true);
	edit_gpis_box->setDisabled(true);
	edit_gpos_label->setDisabled(true);
	edit_gpos_box->setDisabled(true);
	edit_username_label->setDisabled(true);
	edit_username_edit->setDisabled(true);
	edit_password_label->setDisabled(true);
	edit_password_edit->setDisabled(true);
	edit_displays_label->setDisabled(true);
	edit_displays_box->setDisabled(true);
	edit_vguestrelays_button->setDisabled(true);
	edit_vguestdisplays_button->setDisabled(true);
	break;
  }
  portTypeActivatedData(edit_porttype_box->currentItem());
}


QSize EditMatrix::sizeHint() const
{
  return QSize(420,420);
} 


QSizePolicy EditMatrix::sizePolicy() const
{
  return QSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
}


void EditMatrix::portTypeActivatedData(int index)
{
  switch((RDMatrix::PortType)edit_porttype_box->currentItem()) {
      case RDMatrix::TtyPort:
	switch(edit_matrix->type()) {
	    case RDMatrix::LocalGpio:
	    case RDMatrix::LocalAudioAdapter:
	      edit_port_box->setDisabled(true);
	      edit_port_label->setDisabled(true);
	      break;

	    default:
	      edit_port_box->setEnabled(true);
	      edit_port_label->setEnabled(true);
	      break;
	}
	edit_ipaddress_edit->setDisabled(true);
	edit_ipaddress_label->setDisabled(true);
	edit_ipport_spin->setDisabled(true);
	edit_ipport_label->setDisabled(true);
	break;
	
      case RDMatrix::TcpPort:
	edit_port_box->setDisabled(true);
	edit_port_label->setDisabled(true);
	edit_ipaddress_edit->setEnabled(true);
	edit_ipaddress_label->setEnabled(true);
	edit_ipport_spin->setEnabled(true);
	edit_ipport_label->setEnabled(true);
	break;
  }
}


void EditMatrix::inputsButtonData()
{
  WriteMatrix();
  ListEndpoints *ep=new ListEndpoints(edit_matrix,RDMatrix::Input,this);
  ep->exec();
  delete ep;
}


void EditMatrix::outputsButtonData()
{
  WriteMatrix();
  ListEndpoints *ep=new ListEndpoints(edit_matrix,RDMatrix::Output,this);
  ep->exec();
  delete ep;
}


void EditMatrix::xpointsButtonData()
{
}


void EditMatrix::gpisButtonData()
{
  WriteMatrix();
  ListGpis *ep=new ListGpis(edit_matrix,this);
  ep->exec();
  delete ep;
}


void EditMatrix::gpisChangedData(int value)
{
  if(edit_matrix->type()==RDMatrix::LogitekVguest) {
    edit_gpos_box->setValue(value);
  }
  if(value>0) {
    edit_gpis_button->setEnabled(true);
  }
  else {
    edit_gpis_button->setDisabled(true);
  }
}


void EditMatrix::gposChangedData(int value)
{
  if(edit_matrix->type()==RDMatrix::LogitekVguest) {
    edit_gpis_box->setValue(value);
    if(value>0) {
      edit_gpis_button->setEnabled(true);
    }
    else {
      edit_gpis_button->setDisabled(true);
    }
  }
}


void EditMatrix::vguestRelaysButtonData()
{
  ListVguestResources*dialog=
    new ListVguestResources(edit_matrix,RDMatrix::VguestTypeRelay,
			    edit_gpos_box->value(),this,"dialog");
  dialog->exec();
  delete dialog;
}


void EditMatrix::vguestDisplaysButtonData()
{
  ListVguestResources*dialog=
    new ListVguestResources(edit_matrix,RDMatrix::VguestTypeDisplay,
			    edit_displays_box->value(),this,"dialog");
  dialog->exec();
  delete dialog;
}


void EditMatrix::okData()
{
  if(!WriteMatrix()) {
    QMessageBox::warning(this,tr("Invalid Address"),
			 tr("The IP address is invalid!"));
    return;
  }
  done(0);
}


void EditMatrix::cancelData()
{
  done(1);
}


bool EditMatrix::WriteMatrix()
{
  QHostAddress addr;

  switch((RDMatrix::PortType)edit_porttype_box->currentItem()) {
      case RDMatrix::TtyPort:
	edit_matrix->setPortType(RDMatrix::TtyPort);
	edit_matrix->setPort(edit_port_box->currentItem());
	edit_matrix->setIpAddress(QHostAddress());
	edit_matrix->setIpPort(0);
	break;

      case RDMatrix::TcpPort:
	if(!addr.setAddress(edit_ipaddress_edit->text())) {
	  return false;
	}
	edit_matrix->setPortType(RDMatrix::TcpPort);
	edit_matrix->setPort(-1);
	edit_matrix->setIpAddress(addr);
	edit_matrix->setIpPort(edit_ipport_spin->value());
	break;
  }
  edit_matrix->setName(edit_name_edit->text());
  edit_matrix->setCard(edit_card_box->value());
  edit_matrix->setInputs(edit_inputs_box->value());
  edit_matrix->setOutputs(edit_outputs_box->value());
  edit_matrix->setGpioDevice(edit_device_edit->text());
  edit_matrix->setGpis(edit_gpis_box->value());
  edit_matrix->setGpos(edit_gpos_box->value());
  edit_matrix->setUsername(edit_username_edit->text());
  edit_matrix->setPassword(edit_password_edit->text());
  edit_matrix->setDisplays(edit_displays_box->value());

  return true;
}
