// edit_now_next.cpp
//
// Edit the Now & Next Configuration for a Rivendell Workstation.
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: edit_now_next.cpp,v 1.6 2007/02/14 21:51:02 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qmessagebox.h>

#include <rdtextvalidator.h>

#include <edit_now_next.h>
#include <globals.h>


EditNowNext::EditNowNext(RDAirPlayConf *conf,QWidget *parent,const char *name)
  : QDialog(parent,name,true)
{
  nownext_conf=conf;

  //
  // Create Fonts
  //
  QFont font=QFont("Helvetica",12,QFont::Bold);
  font.setPixelSize(12);
  QFont section_font=QFont("Helvetica",14,QFont::Bold);
  section_font.setPixelSize(14);

  //
  // Fix the Window Size
  //
  setMinimumWidth(sizeHint().width());
  setMaximumWidth(sizeHint().width());
  setMinimumHeight(sizeHint().height());
  setMaximumHeight(sizeHint().height());

  setCaption(tr("Edit Now & Next Data"));

  //
  // Text Validator
  //
  RDTextValidator *validator=new RDTextValidator(this,"validator");

  //
  // Master Log Label
  //
  QLabel *label=new QLabel(tr("Master Log"),this,"masterlog_label");
  label->setGeometry(10,7,100,19);
  label->setFont(section_font);
  label->setAlignment(AlignLeft|AlignVCenter);

  //
  // Master Log UDP Address
  //
  nownext_address_edit[0]=new QLineEdit(this,"nownext_address_edit[0]");
  nownext_address_edit[0]->setGeometry(115,33,120,19);
  label=new QLabel(nownext_address_edit[0],tr("IP Address:"),this,
		   "nownext_address_label");
  label->setGeometry(10,33,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Master Log UDP Port
  //
  nownext_port_spin[0]=new QSpinBox(this,"nownext_port_spin[0]");
  nownext_port_spin[0]->setGeometry(355,33,60,19);
  nownext_port_spin[0]->setRange(0,65535);
  label=new QLabel(nownext_port_spin[0],tr("UDP Port:"),this,"nownext_port_label");
  label->setGeometry(250,33,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Master Log UDP String
  //
  nownext_string_edit[0]=new QLineEdit(this,"nownext_string_edit[0]");
  nownext_string_edit[0]->setGeometry(115,55,sizeHint().width()-125,19);
  label=new QLabel(nownext_string_edit[0],
			   tr("UDP String:"),this,
			   "nownext_string_label");
  label->setGeometry(10,55,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Master Log RML
  //
  nownext_rml_edit[0]=new QLineEdit(this,"nownext_rml_edit[0]");
  nownext_rml_edit[0]->setGeometry(115,85,sizeHint().width()-125,19);
  nownext_rml_edit[0]->setValidator(validator);
  label=new QLabel(nownext_rml_edit[0],
			   tr("RML:"),this,
			   "nownext_rml_label");
  label->setGeometry(10,85,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Aux Log 1 Label
  //
  label=new QLabel(tr("Aux Log 1"),this,"masterlog_label");
  label->setGeometry(10,115,100,19);
  label->setFont(section_font);
  label->setAlignment(AlignLeft|AlignVCenter);

  //
  // Aux Log 1 UDP Address
  //
  nownext_address_edit[1]=new QLineEdit(this,"nownext_address_edit[1]");
  nownext_address_edit[1]->setGeometry(115,141,120,19);
  label=new QLabel(nownext_address_edit[1],tr("IP Address:"),this,
		   "nownext_address_label");
  label->setGeometry(10,141,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Aux Log 1 UDP Port
  //
  nownext_port_spin[1]=new QSpinBox(this,"nownext_port_spin[1]");
  nownext_port_spin[1]->setGeometry(355,141,60,19);
  nownext_port_spin[1]->setRange(0,65535);
  label=new QLabel(nownext_port_spin[1],tr("UDP Port:"),
		   this,"nownext_port_label");
  label->setGeometry(250,141,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Aux Log 1 UDP String
  //
  nownext_string_edit[1]=new QLineEdit(this,"nownext_string_edit[1]");
  nownext_string_edit[1]->setGeometry(115,163,sizeHint().width()-125,19);
  label=new QLabel(nownext_string_edit[1],tr("UDP String:"),this,
			   "nownext_string_label");
  label->setGeometry(10,163,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Aux Log 1 RML
  //
  nownext_rml_edit[1]=new QLineEdit(this,"nownext_rml_edit[1]");
  nownext_rml_edit[1]->setGeometry(115,193,sizeHint().width()-125,19);
  nownext_rml_edit[1]->setValidator(validator);
  label=new QLabel(nownext_rml_edit[1],
			   tr("RML:"),this,
			   "nownext_rml_label");
  label->setGeometry(10,193,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Aux Log 2 Label
  //
  label=new QLabel("Aux Log 2",this,"masterlog_label");
  label->setGeometry(10,222,100,19);
  label->setFont(section_font);
  label->setAlignment(AlignLeft|AlignVCenter);

  //
  // Aux Log 2 UDP Address
  //
  nownext_address_edit[2]=new QLineEdit(this,"nownext_address_edit[2]");
  nownext_address_edit[2]->setGeometry(115,248,120,19);
  label=new QLabel(nownext_address_edit[2],tr("IP Address:"),this,
		   "nownext_address_label");
  label->setGeometry(10,248,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Aux Log 2 UDP Port
  //
  nownext_port_spin[2]=new QSpinBox(this,"nownext_port_spin[2]");
  nownext_port_spin[2]->setGeometry(355,248,60,19);
  nownext_port_spin[2]->setRange(0,65535);
  label=new QLabel(nownext_port_spin[2],tr("UDP Port:"),
		   this,"nownext_port_label");
  label->setGeometry(250,248,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Aux Log 2 UDP String
  //
  nownext_string_edit[2]=new QLineEdit(this,"nownext_string_edit[2]");
  nownext_string_edit[2]->setGeometry(115,270,sizeHint().width()-125,19);
  label=new QLabel(nownext_string_edit[2],tr("UDP String:"),this,
		   "nownext_string_label");
  label->setGeometry(10,270,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Aux Log 2 RML
  //
  nownext_rml_edit[2]=new QLineEdit(this,"nownext_rml_edit[2]");
  nownext_rml_edit[2]->setGeometry(115,300,sizeHint().width()-125,19);
  nownext_rml_edit[2]->setValidator(validator);
  label=new QLabel(nownext_rml_edit[2],
			   tr("RML:"),this,
			   "nownext_rml_label");
  label->setGeometry(10,300,100,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  //  Ok Button
  //
  QPushButton *ok_button=new QPushButton(this,"ok_button");
  ok_button->setGeometry(sizeHint().width()-180,sizeHint().height()-60,80,50);
  ok_button->setDefault(true);
  ok_button->setFont(font);
  ok_button->setText(tr("&OK"));
  connect(ok_button,SIGNAL(clicked()),this,SLOT(okData()));

  //
  //  Cancel Button
  //
  QPushButton *cancel_button=new QPushButton(this,"cancel_button");
  cancel_button->setGeometry(sizeHint().width()-90,sizeHint().height()-60,
			     80,50);
  cancel_button->setFont(font);
  cancel_button->setText(tr("&Cancel"));
  connect(cancel_button,SIGNAL(clicked()),this,SLOT(cancelData()));

  //
  // Populate Fields
  //
  for(int i=0;i<3;i++) {
    nownext_address_edit[i]->setText(nownext_conf->udpAddress(i).toString());
    nownext_port_spin[i]->setValue(nownext_conf->udpPort(i));
    nownext_string_edit[i]->setText(nownext_conf->udpString(i));
    nownext_rml_edit[i]->setText(nownext_conf->logRml(i));
  }
}


EditNowNext::~EditNowNext()
{
}


QSize EditNowNext::sizeHint() const
{
  return QSize(425,403);
} 


QSizePolicy EditNowNext::sizePolicy() const
{
  return QSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
}


void EditNowNext::okData()
{
  QHostAddress addr[3];
  QString str1;
  QString str2;

  for(int i=0;i<3;i++) {
    if(nownext_address_edit[i]->text().isEmpty()) {
      nownext_address_edit[i]->setText("0.0.0.0");
    }
    if(!addr[i].setAddress(nownext_address_edit[i]->text())) {
      str1=QString(tr("The IP address"));
      str2=QString(tr("is invalid!"));
      QMessageBox::warning(this,tr("Invalid Address"),
			   QString().
			   sprintf("%s \"%s\" %s",(const char *)str1,
				   (const char *)nownext_address_edit[i]->
				   text(),
				   (const char *)str2));
      return;
    }
  }
  for(int i=0;i<3;i++) {
    nownext_conf->setUdpAddress(i,addr[i]);
    nownext_conf->setUdpPort(i,(Q_UINT16)nownext_port_spin[i]->value());
    nownext_conf->setUdpString(i,nownext_string_edit[i]->text());
    nownext_conf->setLogRml(i,nownext_rml_edit[i]->text());
  }
  done(0);
}


void EditNowNext::cancelData()
{
  done(-1);
}
