// rdbutton_dialog.h
//
// Button Editor for the SoundPanel in RDAirPlay.
//
//   (C) Copyright 2002-2003 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdbutton_dialog.h,v 1.7 2007/02/14 21:48:41 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef RDBUTTON_DIALOG_H
#define RDBUTTON_DIALOG_H

#include <qdialog.h>
#include <qcombobox.h>
#include <qlineedit.h>

#include <rdpanel_button.h>

class RDButtonDialog : public QDialog
{
  Q_OBJECT
 public:
  RDButtonDialog(QString station_name,QWidget *parent=0,const char *name=0);
  ~RDButtonDialog();
  QSize sizeHint() const;
  QSizePolicy sizePolicy() const;

 public slots:
  int exec(RDPanelButton *button);

 private slots:
  void setCartData();
  void clearCartData();
  void setColorData();
  void okData();
  void cancelData();

 private:
  void DisplayCart(int cartnum);
  QLineEdit *edit_label_edit;
  QLineEdit *edit_cart_edit;
  RDPanelButton *edit_button;
  QString edit_filter;
  QString edit_group;
  QPushButton *edit_color_button;
  int edit_cart;
  QColor edit_color;
  QString edit_station_name;
};


#endif

