// rdbutton_panel.h
//
// The sound panel widget for RDAirPlay
//
//   (C) Copyright 2002-2003 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdbutton_panel.h,v 1.5 2007/02/14 21:48:41 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef RDBUTTON_PANEL_H
#define RDBUTTON_PANEL_H

#include <qwidget.h>
#include <qdatetime.h>
#include <qlabel.h>

#include <rpushbutton.h>
#include <rtransportbutton.h>

#include <rdairplay_conf.h>
#include <rdstation.h>
#include <rduser.h>
#include <rdpanel_button.h>
#include <rdbutton_dialog.h>

//
// Widget Settings
//
#define PANEL_BUTTON_COLUMNS 5
#define PANEL_BUTTON_ROWS 5
#define PANEL_BUTTON_SIZE_X 88
#define PANEL_BUTTON_SIZE_Y 80


class RDButtonPanel
{
 public:
  RDButtonPanel(RDStation *station,bool flash,QWidget *parent);
  QSize sizeHint() const;
  QSizePolicy sizePolicy() const;
  RDPanelButton *panelButton(int row,int col) const;
  void setActionMode(RDAirPlayConf::ActionMode mode);
  void hide();
  void show();
  void clear();

 private:
  RDPanelButton *panel_button[PANEL_BUTTON_ROWS][PANEL_BUTTON_COLUMNS];
  RDStation *panel_station;
};

#endif
