// rdmatrix.h
//
// Abstract a Rivendell Switcher Matrix
//
//   (C) Copyright 2002-2003 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdmatrix.h,v 1.19 2007/02/14 21:48:41 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qsqldatabase.h>
#include <qdatetime.h>
#include <qhostaddress.h>

#ifndef RDMATRIX_H
#define RDMATRIX_H


class RDMatrix
{
 public:
  enum PortType {TtyPort=0,TcpPort=1};
  enum Type {LocalGpio=0,GenericGpo=1,GenericSerial=2,Sas32000=3,Sas64000=4,
	     Unity4000=5,BtSs82=6,Bt10x1=7,Sas64000Gpi=8,Bt16x1=9,Bt8x2=10,
	     BtAcs82=11,SasUsi=12,Bt16x2=13,BtSs124=14,LocalAudioAdapter=15,
	     LogitekVguest=16,BtSs164=17,StarGuideIII=18,BtSs42=19,None=255};
  enum Endpoint {Input=0,Output=1};
  enum Mode {Stereo=0,Left=1,Right=2};
  enum VguestAttribute {VguestEngine=0,VguestDevice=1,VguestSurface=2,
			VguestRelay=3,VguestBuss=4};
  enum VguestType {VguestTypeRelay=0,VguestTypeDisplay=2};
  RDMatrix(const QString &station,int matrix);
  QString station() const;
  int matrix() const;
  bool exists() const;
  RDMatrix::Type type() const;
  void setType(RDMatrix::Type type) const;
  QString typeString() const;
  QString name() const;
  void setName(const QString &name) const;
  PortType portType() const;
  void setPortType(PortType type) const;
  int card() const;
  void setCard(int card) const;
  QHostAddress ipAddress() const;
  void setIpAddress(QHostAddress addr) const;
  int ipPort() const;
  void setIpPort(int port) const;
  QString username() const;
  void setUsername(const QString &name) const;
  QString password() const;
  void setPassword(const QString &passwd) const;
  int port() const;
  void setPort(int port) const;
  int inputs() const;
  void setInputs(int inputs) const;
  QString inputName(int input) const;
  RDMatrix::Mode inputMode(int input) const;
  int outputs() const;
  void setOutputs(int outputs) const;
  QString outputName(int output) const;
  int gpis() const;
  void setGpis(int gpis) const;
  int gpos() const;
  void setGpos(int gpos) const;
  QString gpioDevice() const;
  void setGpioDevice(const QString &gpos) const;
  int faders() const;
  void setFaders(int quan) const;
  int displays() const;
  void setDisplays(int quan) const;

 private:
  QString GetEndpointName(int pointnum,const QString &table) const;
  QVariant GetRow(const QString &param) const;
  void SetRow(const QString &param,const QString &value) const;
  void SetRow(const QString &param,int value) const;
  QString mx_station;
  int mx_number;
};


#endif 
