// rdstation.h
//
// Abstract a Rivendell Workstation
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdstation.h,v 1.11 2007/02/14 21:48:41 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qsqldatabase.h>
#include <qhostaddress.h>

#ifndef RDSTATION_H
#define RDSTATION_H

class RDStation
{
 public:
  enum AudioDriver {None=0,Hpi=1,Jack=2,Alsa=3};
  enum Capability {HaveOggenc=0,HaveOgg123=1,HaveFlac=2,
		   HaveLame=3,HaveMpg321=4};
  RDStation(QString name,bool create=false);
  ~RDStation();
  QString name() const;
  bool exists();
  QString description();
  void setDescription(QString path);
  QString userName();
  void setUserName(QString name);
  QString defaultName();
  void setDefaultName(QString name);
  QHostAddress address();
  void setAddress(QHostAddress addr);
  int timeOffset();
  void setTimeOffset(int msecs);
  QString backupPath();
  void setBackupPath(QString path);
  int backupLife();
  void setBackupLife(int days);
  unsigned heartbeatCart();
  void setHeartbeatCart(unsigned cartnum);
  unsigned heartbeatInterval();
  void setHeartbeatInterval(unsigned interval);
  bool scanned();
  void setScanned(bool state);
  bool haveCapability(Capability cap);
  void setHaveCapability(Capability cap,bool state);
  int cards();
  RDStation::AudioDriver cardDriver(int cardnum);
  void setCardDriver(int cardnum,AudioDriver driver);
  QString driverVersion(AudioDriver driver);
  void setDriverVersion(AudioDriver driver,QString ver);
  QString cardName(int cardnum);
  void setCardName(int cardnum,QString name);
  int cardInputs(int cardnum);
  void setCardInputs(int cardnum,int inputs);
  int cardOutputs(int cardnum);
  void setCardOutputs(int cardnum,int outputs);

 private:
  void SetRow(QString param,QString value);
  void SetRow(QString param,int value);
  void SetRow(QString param,unsigned value);
  void SetRow(QString param,bool value);
  QString station_name;
};


#endif 
