// edit_group.cpp
//
// Edit a Rivendell Group
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: edit_group.cpp,v 1.21 2007/02/14 21:51:02 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qdialog.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qtextedit.h>
#include <qpainter.h>
#include <qevent.h>
#include <qmessagebox.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qsqldatabase.h>
#include <qcolordialog.h>

#include <rconf.h>
#include <rlistselector.h>
#include <math.h>

#include <edit_group.h>
#include <rduser.h>
#include <rdpasswd.h>
#include <rdtextvalidator.h>


EditGroup::EditGroup(QString group,QWidget *parent,const char *name)
  : QDialog(parent,name,true)
{
  QString sql;
  QSqlQuery *q;

  //
  // Fix the Window Size
  //
  setMinimumWidth(sizeHint().width());
  setMaximumWidth(sizeHint().width());
  setMinimumHeight(sizeHint().height());
  setMaximumHeight(sizeHint().height());

  group_group=new RDGroup(group);

  setCaption(tr("Group: ")+group);

  //
  // Create Fonts
  //
  QFont font=QFont("Helvetica",12,QFont::Bold);
  font.setPixelSize(12);

  //
  // Text Validator
  //
  RDTextValidator *validator=new RDTextValidator(this,"validator");

  //
  // Group Name
  //
  group_name_edit=new QLineEdit(this,"group_name_edit");
  group_name_edit->setGeometry(165,11,100,19);
  group_name_edit->setMaxLength(10);
  group_name_edit->setReadOnly(true);
  QLabel *group_name_label=new QLabel(group_name_edit,tr("&Group Name:"),this,
				       "group_name_label");
  group_name_label->setGeometry(10,11,150,19);
  group_name_label->setFont(font);
  group_name_label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Group Description
  //
  group_description_edit=new QLineEdit(this,"group_description_edit");
  group_description_edit->setGeometry(165,32,sizeHint().width()-175,19);
  group_description_edit->setMaxLength(255);
  group_description_edit->setValidator(validator);
  QLabel *group_description_label=new QLabel(group_description_edit,
					     tr("Group &Description:"),this,
					     "group_description_label");
  group_description_label->setGeometry(10,32,150,19);
  group_description_label->setFont(font);
  group_description_label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Default Cart Type
  //
  group_carttype_box=new QComboBox(this,"group_carttype_box");
  group_carttype_box->setGeometry(165,53,100,19);
  group_carttype_box->insertItem(tr("Audio"));
  group_carttype_box->insertItem(tr("Macro"));
  QLabel *group_carttype_label=new QLabel(group_carttype_box,
					     tr("Default Cart &Type:"),this,
					     "group_carttype_label");
  group_carttype_label->setGeometry(10,53,150,19);
  group_carttype_label->setFont(font);
  group_carttype_label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);

  //
  // Default Cart Numbers
  //
  group_lowcart_box=new QSpinBox(this,"group_lowcart_box");
  group_lowcart_box->setGeometry(165,74,70,19);
  group_lowcart_box->setRange(0,999999);
  group_lowcart_box->setSpecialValueText(tr("None"));
  QLabel *label=new QLabel(group_lowcart_box,
			   tr("Default Cart Number:"),this,
			   "group_lowcart_label");
  label->setGeometry(10,74,150,19);
  label->setFont(font);
  label->setAlignment(AlignRight|AlignVCenter|ShowPrefix);
  group_highcart_box=new QSpinBox(this,"group_highcart_box");
  group_highcart_box->setGeometry(265,74,70,19);
  group_highcart_box->setRange(1,999999);
  group_highcart_label=new QLabel(group_highcart_box,
				  tr("to"),this,
				  "group_highcart_label");
  group_highcart_label->setGeometry(240,74,20,19);
  group_highcart_label->setFont(font);
  group_highcart_label->setAlignment(AlignCenter|ShowPrefix);
  connect(group_lowcart_box,SIGNAL(valueChanged(int)),
	  this,SLOT(lowCartChangedData(int)));

  //
  // Enforce Cart Range Checkbox
  //
  group_enforcerange_box=new QCheckBox(this,"group_enforcerange_box");
  group_enforcerange_box->setGeometry(20,97,15,15);
  group_enforcerange_label=
    new QLabel(group_enforcerange_box,tr("Enforce Cart Range"),
	       this,"group_enforcerange_label");
  group_enforcerange_label->setGeometry(40,95,sizeHint().width()-50,19);
  group_enforcerange_label->setFont(font);
  group_enforcerange_label->setAlignment(AlignLeft|AlignVCenter|ShowPrefix);

  //
  // Traffic Report Checkbox
  //
  group_traffic_box=new QCheckBox(this,"group_traffic_box");
  group_traffic_box->setGeometry(20,124,15,15);
  label=
    new QLabel(group_traffic_box,tr("Include this group in Traffic reports"),
	       this,"group_traffic_label");
  label->setGeometry(40,122,sizeHint().width()-50,19);
  label->setFont(font);
  label->setAlignment(AlignLeft|AlignVCenter|ShowPrefix);

  //
  // Music Report Checkbox
  //
  group_music_box=new QCheckBox(this,"group_music_box");
  group_music_box->setGeometry(20,145,15,15);
  label=new QLabel(group_music_box,tr("Include this group in Music reports"),
		   this,"group_music_label");
  label->setGeometry(40,143,sizeHint().width()-50,19);
  label->setFont(font);
  label->setAlignment(AlignLeft|AlignVCenter|ShowPrefix);

  //
  // Now & Next Data Checkbox
  //
  group_nownext_box=new QCheckBox(this,"group_nownext_box");
  group_nownext_box->setGeometry(20,182,15,15);
  label=new QLabel(group_nownext_box,tr("Transmit Now && Next data"),
		   this,"group_nownext_label");
  label->setGeometry(40,181,sizeHint().width()-50,19);
  label->setFont(font);
  label->setAlignment(AlignLeft|AlignVCenter|ShowPrefix);

  //
  // Services Selector
  //
  group_svcs_sel=new RListSelector(this,"group_svcs_sel");
  group_svcs_sel->setGeometry(10,205,380,130);

  //
  //  Color Button
  //
  group_color_button=new QPushButton(this,"group_colorbutton");
  group_color_button->setGeometry(10,sizeHint().height()-60,80,50);
  group_color_button->setFont(font);
  group_color_button->setText(tr("C&olor"));
  connect(group_color_button,SIGNAL(clicked()),this,SLOT(colorData()));

  //
  //  Ok Button
  //
  QPushButton *ok_button=new QPushButton(this,"ok_button");
  ok_button->setGeometry(sizeHint().width()-180,sizeHint().height()-60,80,50);
  ok_button->setDefault(true);
  ok_button->setFont(font);
  ok_button->setText(tr("&OK"));
  connect(ok_button,SIGNAL(clicked()),this,SLOT(okData()));

  //
  //  Cancel Button
  //
  QPushButton *cancel_button=new QPushButton(this,"cancel_button");
  cancel_button->setGeometry(sizeHint().width()-90,sizeHint().height()-60,
			     80,50);
  cancel_button->setFont(font);
  cancel_button->setText(tr("&Cancel"));
  connect(cancel_button,SIGNAL(clicked()),this,SLOT(cancelData()));

  //
  // Populate Fields
  //
  group_name_edit->setText(group_group->name());
  group_description_edit->setText(group_group->description());
  group_carttype_box->setCurrentItem(group_group->defaultCartType()-1);
  group_lowcart_box->setValue(group_group->defaultLowCart());
  group_highcart_box->setValue(group_group->defaultHighCart());
  lowCartChangedData(group_group->defaultLowCart());
  group_enforcerange_box->setChecked(group_group->enforceCartRange());
  group_traffic_box->setChecked(group_group->exportReport(RDGroup::Traffic));
  group_music_box->setChecked(group_group->exportReport(RDGroup::Music));
  group_nownext_box->setChecked(group_group->enableNowNext());
  sql=QString().sprintf("select SERVICE_NAME from AUDIO_PERMS \
                         where GROUP_NAME=\"%s\"",
			(const char *)group_group->name());
  q=new QSqlQuery(sql);
  while(q->next()) {
    group_svcs_sel->destInsertItem(q->value(0).toString());
  }
  delete q;

  sql=QString().sprintf("select NAME from SERVICES");
  q=new QSqlQuery(sql);
  while(q->next()) {
    if(group_svcs_sel->destFindItem(q->value(0).toString())==0) {
      group_svcs_sel->sourceInsertItem(q->value(0).toString());
    }
  }
  delete q;
  SetButtonColor(group_group->color());
}


EditGroup::~EditGroup()
{
  delete group_name_edit;
  delete group_description_edit;
  delete group_svcs_sel;
}


QSize EditGroup::sizeHint() const
{
  return QSize(400,407);
} 


QSizePolicy EditGroup::sizePolicy() const
{
  return QSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
}


void EditGroup::lowCartChangedData(int value)
{
  if(value==0) {
    group_highcart_box->setRange(0,0);
    group_highcart_label->setDisabled(true);
    group_highcart_box->setDisabled(true);
    group_enforcerange_box->setDisabled(true);
    group_enforcerange_label->setDisabled(true);
  }
  else {
    group_highcart_label->setEnabled(true);
    group_highcart_box->setEnabled(true);
    group_highcart_box->setRange(value,999999); 
    group_enforcerange_box->setEnabled(true);
    group_enforcerange_label->setEnabled(true);
 }
}


void EditGroup::colorData()
{
  QColor color=QColorDialog::getColor(group_color_button->
				      palette().color(QPalette::Active,
						      QColorGroup::ButtonText),
				      this,"color_dialog");
  if(color.isValid()) {
    SetButtonColor(color);
  }
}


void EditGroup::okData()
{
  QSqlQuery *q;
  QString sql;

  if(!CheckRange()) {
    return;
  }

  group_group->setDescription(group_description_edit->text());
  group_group->
    setDefaultCartType((RDCart::Type)(group_carttype_box->currentItem()+1));
  group_group->setDefaultLowCart(group_lowcart_box->value());
  group_group->setDefaultHighCart(group_highcart_box->value());
  if(group_lowcart_box->value()==0) {
    group_group->setEnforceCartRange(false);
  }
  else {
    group_group->setEnforceCartRange(group_enforcerange_box->isChecked());
  }
  group_group->
    setExportReport(RDGroup::Traffic,group_traffic_box->isChecked());
  group_group->setExportReport(RDGroup::Music,group_music_box->isChecked());
  group_group->setEnableNowNext(group_nownext_box->isChecked());
  group_group->setColor(group_color_button->
			palette().color(QPalette::Active,
					QColorGroup::ButtonText));

  //
  // Add New Services
  //
  for(unsigned i=0;i<group_svcs_sel->destCount();i++) {
    sql=QString().sprintf("select SERVICE_NAME from AUDIO_PERMS \
where GROUP_NAME=\"%s\" && SERVICE_NAME=\"%s\"",
			  (const char *)group_group->name(),
			  (const char *)group_svcs_sel->destText(i));
    q=new QSqlQuery(sql);
    if(q->size()==0) {
      delete q;
      sql=QString().sprintf("insert into AUDIO_PERMS (GROUP_NAME,SERVICE_NAME) \
values (\"%s\",\"%s\")",
			    (const char *)group_group->name(),
			    (const char *)group_svcs_sel->destText(i));
      q=new QSqlQuery(sql);
    }
    delete q;
  }

  //
  // Delete Old Services
  //
  sql=QString().sprintf("delete from AUDIO_PERMS where GROUP_NAME=\"%s\"",
			(const char *)group_group->name());
  for(unsigned i=0;i<group_svcs_sel->destCount();i++) {
    sql+=QString().sprintf(" && SERVICE_NAME<>\"%s\"",
			   (const char *)group_svcs_sel->destText(i));
  }
  q=new QSqlQuery(sql);
  delete q;

  done(0);
}


void EditGroup::cancelData()
{
  done(-1);
}


bool EditGroup::CheckRange()
{
  if(group_lowcart_box->value()==0) {
    return true;
  }

  bool conflict_found=false;
  QString sql;
  QSqlQuery *q;
  QString msg=
    tr("The selected cart range conflicts with the following groups:\n\n");

  sql=QString().sprintf("select NAME,DEFAULT_LOW_CART,DEFAULT_HIGH_CART\
                         from GROUPS where NAME!=\"%s\"",
			(const char *)group_name_edit->text());
  q=new QSqlQuery(sql);
  while(q->next()) {
    if(((group_lowcart_box->value()<=q->value(1).toInt())&&
	(group_highcart_box->value()>=q->value(1).toInt()))||
       ((group_lowcart_box->value()<=q->value(2).toInt())&&
	(group_highcart_box->value()>=q->value(2).toInt()))) {
      msg+=QString().sprintf("    %s\n",(const char *)q->value(0).toString());
      conflict_found=true;
    }
  }
  delete q;

  if(conflict_found) {
    msg+=tr("\nDo you still want to save?");
    switch(QMessageBox::warning(this,"Conflict Found",msg,
				QMessageBox::Yes,QMessageBox::No)) {
	case QMessageBox::No:
	case QMessageBox::NoButton:
	  return false;

	default:
	  break;
    }
  }
  return true;
}


void EditGroup::SetButtonColor(const QColor &color)
{
  QPalette p=group_color_button->palette();
  p.setColor(QColorGroup::ButtonText,color);
  group_color_button->setPalette(p);
}
