// rdmatrix.cpp
//
// Abstract a Rivendell Switcher Matrix
//
//   (C) Copyright 2002-2003 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdmatrix.cpp,v 1.19 2007/02/14 21:48:41 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <rdmatrix.h>


RDMatrix::RDMatrix(const QString &station,int matrix)
{
  mx_station=station;
  mx_number=matrix;
}


QString RDMatrix::station() const
{
  return mx_station;
}


int RDMatrix::matrix() const
{
  return mx_number;
}


bool RDMatrix::exists() const
{
  QString sql=QString().sprintf("select TYPE from MATRICES where MATRIX=%d",
				mx_number);
  QSqlQuery *q=new QSqlQuery(sql);
  bool result=q->first();
  delete q;
  return result;
}


RDMatrix::Type RDMatrix::type() const
{
  return (RDMatrix::Type)GetRow("TYPE").toInt();
}


void RDMatrix::setType(RDMatrix::Type type) const
{
  SetRow("TYPE",type);
}


QString RDMatrix::typeString() const
{
  switch(type()) {
      case RDMatrix::LocalGpio:
	return QString("Local GPIO");
	break;

      case RDMatrix::GenericGpo:
	return QString("Generic GPO");
	break;

      case RDMatrix::GenericSerial:
	return QString("Generic Serial");
	break;

      case RDMatrix::Sas32000:
	return QString("SAS 32000");
	break;

      case RDMatrix::Sas64000:
	return QString("SAS 64000");
	break;

      case RDMatrix::Unity4000:
	return QString("Wegener Unity 4000");
	break;

      case RDMatrix::BtSs82:
	return QString("BroadcastTools SS8.2");
	break;

      case RDMatrix::Bt10x1:
	return QString("BroadcastTools 10x1");
	break;

      case RDMatrix::Sas64000Gpi:
	return QString("SAS 64000-GPI");
	break;

      case RDMatrix::Bt16x1:
	return QString("BroadcastTools 16x1");
	break;

      case RDMatrix::Bt8x2:
	return QString("BroadcastTools 8x2");
	break;

      case RDMatrix::BtAcs82:
	return QString("BroadcastTools ACS 8.2");
	break;

      case RDMatrix::SasUsi:
	return QString("SAS User Serial Interface");
	break;

      case RDMatrix::Bt16x2:
	return QString("BroadcastTools 16x2");
	break;

      case RDMatrix::BtSs124:
	return QString("BroadcastTools SS12.4");
	break;

      case RDMatrix::LocalAudioAdapter:
	return QString("Local Audio Adapter");
	break;

      case RDMatrix::LogitekVguest:
	return QString("Logitek vGuest");
	break;

      case RDMatrix::BtSs164:
	return QString("BroadcastTools SS16.4");
	break;

      case RDMatrix::StarGuideIII:
	return QString("StarGuide III");
	break;

      case RDMatrix::BtSs42:
	return QString("BroadcastTools SS4.2");
	break;

      default:
	return QString("Unknown Type");
	break;
  }
  return QString("Unknown Type");
}


QString RDMatrix::name() const
{
  return GetRow("NAME").toString();
}


void RDMatrix::setName(const QString &name) const
{
  SetRow("NAME",name);
}


RDMatrix::PortType RDMatrix::portType() const
{
  return (RDMatrix::PortType)GetRow("PORT_TYPE").toInt();
}


void RDMatrix::setPortType(PortType type) const
{
  SetRow("PORT_TYPE",(int)type);
}


QHostAddress RDMatrix::ipAddress() const
{
  QHostAddress addr;
  addr.setAddress(GetRow("IP_ADDRESS").toString());
  return addr;
}


void RDMatrix::setIpAddress(QHostAddress addr) const
{
  SetRow("IP_ADDRESS",addr.toString());
}


int RDMatrix::card() const
{
  return GetRow("CARD").toInt();
}


void RDMatrix::setCard(int card) const
{
  SetRow("CARD",card);
}


int RDMatrix::ipPort() const
{
  return GetRow("IP_PORT").toInt();
}


void RDMatrix::setIpPort(int port) const
{
  SetRow("IP_PORT",port);
}


QString RDMatrix::username() const
{
  return GetRow("USERNAME").toString();
}


void RDMatrix::setUsername(const QString &name) const
{
  SetRow("USERNAME",name);
}


QString RDMatrix::password() const
{
  return GetRow("PASSWORD").toString();
}


void RDMatrix::setPassword(const QString &passwd) const
{
  SetRow("PASSWORD",passwd);
}


int RDMatrix::port() const
{
  return GetRow("PORT").toInt();
}


void RDMatrix::setPort(int port) const
{
  SetRow("PORT",port);
}


int RDMatrix::inputs() const
{
  return GetRow("INPUTS").toInt();
}


void RDMatrix::setInputs(int inputs) const
{
  SetRow("INPUTS",inputs);
}


QString RDMatrix::inputName(int input) const
{
  return GetEndpointName(input,"INPUTS");
}


RDMatrix::Mode RDMatrix::inputMode(int input) const
{
  QString sql=QString().sprintf("select CHANNEL_MODE from INPUTS where \
                                 STATION_NAME=\"%s\" && \
                                 MATRIX=%d && NUMBER=%d",
				(const char *)mx_station,
				mx_number,
				input);
  QSqlQuery *q=new QSqlQuery(sql);
  if(!q->first()) {
    delete q;
    return RDMatrix::Stereo;
  }
  RDMatrix::Mode mode=(RDMatrix::Mode)q->value(0).toInt();
  delete q;
  return mode;
}


int RDMatrix::outputs() const
{
  return GetRow("OUTPUTS").toInt();
}


void RDMatrix::setOutputs(int outputs) const
{
  SetRow("OUTPUTS",outputs);
}


QString RDMatrix::outputName(int output) const
{
  return GetEndpointName(output,"OUTPUTS");
}


int RDMatrix::gpis() const
{
  return GetRow("GPIS").toInt();
}


void RDMatrix::setGpis(int gpis) const
{
  SetRow("GPIS",gpis);
}


int RDMatrix::gpos() const
{
  return GetRow("GPOS").toInt();
}


void RDMatrix::setGpos(int gpos) const
{
  SetRow("GPOS",gpos);
}


QString RDMatrix::gpioDevice() const
{
  return GetRow("GPIO_DEVICE").toString();
}


void RDMatrix::setGpioDevice(const QString &dev) const
{
  SetRow("GPIO_DEVICE",dev);
}


int RDMatrix::faders() const
{
  return GetRow("FADERS").toInt();
}


void RDMatrix::setFaders(int quan) const
{
  SetRow("FADERS",quan);
}


int RDMatrix::displays() const
{
  return GetRow("DISPLAYS").toInt();
}


void RDMatrix::setDisplays(int quan) const
{
  SetRow("DISPLAYS",quan);
}


QString RDMatrix::GetEndpointName(int pointnum,const QString &table) const
{
  QString sql=QString().sprintf("select NAME from %s where \
                                 STATION_NAME=\"%s\" && \
                                 MATRIX=%d && NUMBER=%d",
				(const char *)table,
				(const char *)mx_station,
				mx_number,
				pointnum);
  QSqlQuery *q=new QSqlQuery(sql);
  if(!q->first()) {
    delete q;
    return QString("NULL");
  }
  QString str=q->value(0).toString();
  delete q;
  return str;
}


QVariant RDMatrix::GetRow(const QString &param) const
{
  QVariant var;
  QString sql=QString().sprintf("select %s from MATRICES where \
                                STATION_NAME=\"%s\" && MATRIX=%d",
				(const char *)param,
				(const char *)mx_station,
                                mx_number);
  QSqlQuery *q=new QSqlQuery(sql);
  if(q->first()) {
    var=q->value(0);
  }
  delete q;
  return var;
}


void RDMatrix::SetRow(const QString &param,const QString &value) const
{
  QSqlQuery *q;
  QString sql;

  sql=QString().sprintf("UPDATE MATRICES SET %s=\"%s\" \
                         WHERE STATION_NAME=\"%s\" && MATRIX=%d",
			(const char *)param,
			(const char *)value,
			(const char *)mx_station,
			mx_number);
  q=new QSqlQuery(sql);
  delete q;
}


void RDMatrix::SetRow(const QString &param,int value) const
{
  QSqlQuery *q;
  QString sql;

  sql=QString().sprintf("UPDATE MATRICES SET %s=%d \
                         WHERE STATION_NAME=\"%s\" && MATRIX=%d",
			(const char *)param,
			value,
			(const char *)mx_station,
			mx_number);
  q=new QSqlQuery(sql);
  delete q;
}
