// edit_gpi.h
//
// Edit a Rivendell GPI
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: edit_gpi.h,v 1.5 2007/02/14 21:51:02 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef EDIT_GPI_H
#define EDIT_GPI_H

#include <qdialog.h>
#include <qsqldatabase.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcombobox.h>

#include <rduser.h>
#include <rdmatrix.h>


class EditGpi : public QDialog
{
 Q_OBJECT
 public:
  EditGpi(int gpi,int *cart,QString *desc,
	  QWidget *parent=0,const char *name=0);
  QSize sizeHint() const;
  QSizePolicy sizePolicy() const;

 private slots:
  void selectData();
  void clearData();
  void okData();
  void cancelData();

 private:
  int edit_gpi;
  int *edit_cart;
  QLineEdit *edit_description_edit;
  QLineEdit *edit_macro_edit;
  QString edit_filter;
  QString edit_group;
  QString *edit_description;
};


#endif  // EDIT_GPI

