// list_users.cpp
//
// List Rivendell Users
//
//   (C) Copyright 2002-2003 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: list_users.cpp,v 1.18 2007/06/12 16:06:11 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qdialog.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qtextedit.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qevent.h>
#include <qmessagebox.h>
#include <qbuttongroup.h>
#include <qsqldatabase.h>
#include <rconf.h>
#include <math.h>

#include <rdairplay_conf.h>

#include <list_users.h>
#include <edit_user.h>
#include <add_user.h>


ListUsers::ListUsers(QString user,QWidget *parent,const char *name)
  : QDialog(parent,name,true)
{
  //
  // Fix the Window Size
  //
  setMinimumWidth(sizeHint().width());
  setMaximumWidth(sizeHint().width());
  setMinimumHeight(sizeHint().height());
  setMaximumHeight(sizeHint().height());

  list_current_user=user;
  setCaption(tr("Rivendell User List"));

  //
  // Create Fonts
  //
  QFont font=QFont("Helvetica",12,QFont::Bold);
  font.setPixelSize(12);
  QFont small_font=QFont("Helvetica",10,QFont::Bold);
  small_font.setPixelSize(10);

  //
  //  Add Button
  //
  QPushButton *add_button=new QPushButton(this,"add_button");
  add_button->setGeometry(100,30,80,50);
  add_button->setFont(font);
  add_button->setText(tr("&Add"));
  connect(add_button,SIGNAL(clicked()),this,SLOT(addData()));

  //
  //  Edit Button
  //
  QPushButton *edit_button=new QPushButton(this,"edit_button");
  edit_button->setGeometry(100,90,80,50);
  edit_button->setFont(font);
  edit_button->setText(tr("&Edit"));
  connect(edit_button,SIGNAL(clicked()),this,SLOT(editData()));

  //
  //  Delete Button
  //
  QPushButton *delete_button=new QPushButton(this,"delete_button");
  delete_button->setGeometry(100,150,80,50);
  delete_button->setFont(font);
  delete_button->setText(tr("&Delete"));
  connect(delete_button,SIGNAL(clicked()),this,SLOT(deleteData()));

  //
  //  Close Button
  //
  QPushButton *close_button=new QPushButton(this,"close_button");
  close_button->setGeometry(100,240,80,50);
  close_button->setDefault(true);
  close_button->setFont(font);
  close_button->setText(tr("&Close"));
  connect(close_button,SIGNAL(clicked()),this,SLOT(closeData()));

  //
  // User List Box
  //
  list_box=new QListBox(this,"list_box");
  list_box->setGeometry(10,30,80,260);
  QLabel *list_box_label=new QLabel(list_box,tr("&Users:"),
				    this,"list_box_label");
  list_box_label->setFont(font);
  list_box_label->setGeometry(14,11,85,19);
  connect(list_box,SIGNAL(doubleClicked(QListBoxItem *)),
	  this,SLOT(doubleClickedData(QListBoxItem *)));

  RefreshList();
}


ListUsers::~ListUsers()
{
  delete list_box;
}


QSize ListUsers::sizeHint() const
{
  return QSize(200,300);
} 


QSizePolicy ListUsers::sizePolicy() const
{
  return QSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
}


void ListUsers::addData()
{
  QString username;

  AddUser *add_user=new AddUser(&username,this,"add_user");
  if(add_user->exec()<0) {
    delete add_user;
    return;
  }
  delete add_user;
  RefreshList(username);
}


void ListUsers::editData()
{
  if(list_box->currentItem()<0) {
    return;
  }
  EditUser *edit_user=new EditUser(list_box->currentText(),this,"edit_user");
  edit_user->exec();
  delete edit_user;
  edit_user=NULL;
}


void ListUsers::deleteData()
{
  QString sql;
  QSqlQuery *q;
  QString str;

  if(list_box->currentText()==list_current_user) {
    QMessageBox::warning(this,tr("Can't Delete User"),
			 tr("You cannot delete yourself!"),1,0);
    return;
  }

  str=QString((tr("Are you sure you want to delete user")));
  if(QMessageBox::warning(this,tr("Delete User"),
			  QString().sprintf(
			    "%s %s?",(const char *)str,
			    (const char *)list_box->currentText()),
			  QMessageBox::Yes,QMessageBox::No)==
     QMessageBox::Yes) {

    //
    // Delete SoundPanel entries
    //
    sql=QString().sprintf("delete from PANELS where (TYPE=%d && OWNER=\"%s\")",
			  RDAirPlayConf::UserPanel,
			  (const char *)list_box->currentText());
    q=new QSqlQuery(sql);
    delete q;

    sql=QString().sprintf("delete from EXTENDED_PANELS \
                           where (TYPE=%d && OWNER=\"%s\")",
			  RDAirPlayConf::UserPanel,
			  (const char *)list_box->currentText());
    q=new QSqlQuery(sql);
    delete q;

    sql=QString().sprintf("delete from USER_PERMS where USER_NAME=\"%s\"",
			  (const char *)list_box->currentText());
    q=new QSqlQuery(sql);
    delete q;
    sql=QString().sprintf("delete from USERS where LOGIN_NAME=\"%s\"",
			  (const char *)list_box->currentText());
    q=new QSqlQuery(sql);
    delete q;
    list_box->removeItem(list_box->currentItem());
    if(list_box->currentItem()>=0) {
      list_box->setSelected(list_box->currentItem(),true);
    }
  }
}


void ListUsers::closeData()
{
  done(0);
}


void ListUsers::doubleClickedData(QListBoxItem *item)
{
  editData();
}


void ListUsers::paintEvent(QPaintEvent *paintevent)
{
  QPainter *p=new QPainter(this);
    
  p->end();
}


void ListUsers::RefreshList(QString username)
{
  QString sql;
  QSqlQuery *q;

  list_box->clear();
  q=new QSqlQuery("select LOGIN_NAME from USERS");
  while (q->next()) {
    list_box->insertItem(q->value(0).toString());
    if(username==list_box->text(list_box->count()-1)) {
      list_box->setCurrentItem(list_box->count()-1);
    }
  }
  delete q;
}
