// rdcart_search_text.cpp
//
// Generates a standardized SQL 'WHERE' clause for filtering Rivendell carts.
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdcart_search_text.cpp,v 1.15 2007/07/09 07:21:12 stgabriel Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <rdcart_search_text.h>


QString RDBaseSearchText(QString filter)
{
  return QString().sprintf(" ((CART.TITLE like \"%%%s%%\")||\
(CART.ARTIST like \"%%%s%%\")||(CART.CLIENT like \"%%%s%%\")||\
(CART.AGENCY like \"%%%s%%\")||(CART.ALBUM like \"%%%s%%\")||\
(CART.LABEL like \"%%%s%%\")||(CART.NUMBER like \"%%%s%%\")||\
(CART.PUBLISHER like \"%%%s%%\")||(CART.COMPOSER like \"%%%s%%\")||\
(CART.USER_DEFINED like \"%%%s%%\"))",
			   (const char *)filter.utf8(),
			   (const char *)filter.utf8(),
			   (const char *)filter.utf8(),
			   (const char *)filter.utf8(),
			   (const char *)filter.utf8(),
			   (const char *)filter.utf8(),
			   (const char *)filter.utf8(),
			   (const char *)filter.utf8(),
			   (const char *)filter.utf8(),
			   (const char *)filter.utf8());
}

QString RDCartSearchText(QString filter,QString group)
{
  //
  // Basic Filter
  //
  if(group.isEmpty()) {
    return QString().sprintf(" %s",(const char *)RDBaseSearchText(filter).utf8());
  }
  return QString().sprintf(" %s&&(CART.GROUP_NAME=\"%s\")",
			   (const char *)RDBaseSearchText(filter).utf8(),
			   (const char *)group);
}


QString RDAllCartSearchText(QString filter,QString user)
{
  QString sql;
  QSqlQuery *q;
  QString search="(";

  sql=QString().sprintf("select GROUP_NAME from USER_PERMS\
                         where USER_NAME=\"%s\"",
			(const char *)user);
  q=new QSqlQuery(sql);
  while(q->next()) {
    search+=QString().sprintf("(CART.GROUP_NAME=\"%s\")||",
			      (const char *)q->value(0).toString());
  }
  delete q;
  search=search.left(search.length()-2)+QString(")");
  search+=QString("&&")+RDBaseSearchText(filter);
  return search;
}
