// rdrecording.h
//
// Abstract a Rivendell RDCatch Event
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdrecording.h,v 1.21 2007/02/21 17:24:28 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qsqldatabase.h>
#include <qdatetime.h>

#include <rdsettings.h>

#ifndef RDRECORDING_H
#define RDRECORDING_H

class RDRecording
{
 public:
  enum StartType {HardStart=0,GpiStart=1};
  enum EndType {HardEnd=0,GpiEnd=1,LengthEnd=2};
  enum Type {Recording=0,MacroEvent=1,SwitchEvent=2,Playout=3,
	     Download=4,Upload=5};
  enum ExitCode {Ok=0,Short=1,LowLevel=2,HighLevel=3,
		 Downloading=4,Uploading=5,ServerError=6,InternalError=7,
		 Interrupted=8,RecordActive=9,PlayActive=10,Waiting=11,
		 DeviceBusy=12,NoCut=13};
  RDRecording(int id,bool create=false);
  int id() const;
  bool isActive();
  void setIsActive(bool state);
  QString station();
  void setStation(QString name);
  RDRecording::Type type();
  void setType(RDRecording::Type type);
  unsigned channel();
  void setChannel(unsigned chan);
  QTime startTime();
  void setStartTime(QTime time);
  QTime endTime();
  void setEndTime(QTime time);
  QString cutName();
  void setCutName(QString name);
  bool sun();
  void setSun(bool state);
  bool mon();
  void setMon(bool state);
  bool tue();
  void setTue(bool state);
  bool wed();
  void setWed(bool state);
  bool thu();
  void setThu(bool state);
  bool fri();
  void setFri(bool state);
  bool sat();
  void setSat(bool state);
  int switchSource();
  void setSwitchSource(int input);
  int switchDestination();
  void setSwitchDestination(int output);
  QString description();
  void setDescription(QString string);
  unsigned length();
  void setLength(unsigned length);
  int startGpi();
  void setStartGpi(int line);
  int endGpi();
  void setEndGpi(int line);
  bool allowMultipleRecordings();
  void setAllowMultipleRecordings(bool state);
  unsigned maxGpiRecordingLength();
  void setMaxGpiRecordingLength(unsigned len);
  unsigned trimThreshold();
  void setTrimThreshold(unsigned level);
  unsigned startdateOffset();
  void setStartdateOffset(unsigned offset);
  unsigned enddateOffset();
  void setEnddateOffset(unsigned offset);
  RDSettings::Format format();
  void setFormat(RDSettings::Format fmt);
  int channels();
  void setChannels(int chan);
  int samprate();
  void setSamprate(int rate);
  int bitrate();
  void setBitrate(int rate);
  int quality();
  void setQuality(int qual);
  int normalizationLevel();
  void setNormalizationLevel(int level);
  int macroCart();
  void setMacroCart(int cart);
  bool oneShot();
  void setOneShot(bool state);
  StartType startType();
  void setStartType(StartType type);
  EndType endType();
  void setEndType(EndType type);
  int startMatrix();
  void setStartMatrix(int matrix);
  int startLine();
  void setStartLine(int line);
  int endMatrix();
  void setEndMatrix(int matrix);
  int endLine();
  void setEndLine(int line);
  int startLength();
  void setStartLength(int len);
  int endLength();
  void setEndLength(int len);
  int startOffset();
  void setStartOffset(int offset);
  QString url();
  void setUrl(QString url);
  QString urlUsername();
  void setUrlUsername(QString name);
  QString urlPassword();
  void setUrlPassword(QString passwd);
  static QString typeString(RDRecording::Type type);
  
 private:
  int GetIntValue(QString field);
  unsigned GetUIntValue(QString field);
  bool GetBoolValue(QString field);
  QString GetStringValue(QString field);
  QTime GetTimeValue(QString field);
  int AddRecord();
  void SetRow(QString param,int value);
  void SetRow(QString param,unsigned value);
  void SetRow(QString param,bool value);
  void SetRow(QString param,QString value);
  void SetRow(QString param,QTime value);
  int rec_id;
};


#endif 
