// rdsimpleplayer.cpp
//
// A naively simple player for Rivendell Carts.
//
//   (C) Copyright 2002-2006 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdsimpleplayer.cpp,v 1.3 2007/03/12 11:57:01 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <rdsimpleplayer.h>


RDSimplePlayer::RDSimplePlayer(RDCae *cae,RDRipc *ripc,int card,int port,
			       unsigned start_cart,unsigned end_cart,
			       QWidget *parent,const char *name)
  : QWidget(parent,name)
{
  play_cae=cae;
  play_ripc=ripc;
  play_card=card;
  play_port=port;
  play_start_cart=start_cart;
  play_end_cart=end_cart;
  play_stream=-1;
  play_handle=-1;
  play_cart=0;
  play_is_playing=false;

  //
  // RDCae Connections
  //
  connect(play_cae,SIGNAL(playing(int)),this,SLOT(playingData(int)));
  connect(play_cae,SIGNAL(playStopped(int)),this,SLOT(playStoppedData(int)));
  connect(play_cae,SIGNAL(playUnloaded(int)),this,SLOT(playUnloadedData(int)));

  //
  // Event Player
  //
  play_event_player=new RDEventPlayer(play_ripc,this,"play_event_player");

  //
  //  Start Button
  //
  play_start_button=
    new RTransportButton(RTransportButton::Play,parent,"play_start_button");
  connect(play_start_button,SIGNAL(clicked()),this,SLOT(play()));

  //
  //  Stop Button
  //
  play_stop_button=
    new RTransportButton(RTransportButton::Stop,parent,"play_stop_button");
  play_stop_button->on();
  connect(play_stop_button,SIGNAL(clicked()),this,SLOT(stop()));

  hide();
}


RDSimplePlayer::~RDSimplePlayer()
{
}


void RDSimplePlayer::setCart(unsigned cart)
{
  play_cart=cart;
}


RTransportButton *RDSimplePlayer::playButton() const
{
  return play_start_button;
}


RTransportButton *RDSimplePlayer::stopButton() const
{
  return play_stop_button;
}


void RDSimplePlayer::play()
{
  int play_cut_gain=0;
  QString sql;
  QSqlQuery *q;

  if(play_is_playing||(play_cart==0)) {
    return;
  }
  sql=QString().sprintf("select CUT_NAME,START_POINT,END_POINT,PLAY_GAIN from CUTS \
                         where (CART_NUMBER=%u)&&(LENGTH>0)",
			play_cart);
  q=new QSqlQuery(sql);
  if(q->first()) {
    play_cae->
      loadPlay(play_card,q->value(0).toString(),&play_stream,&play_handle);
    play_cut_gain=q->value(3).toInt(); 
    if(play_stream<0) {
      delete q;
      return;
    }
    play_cae->
      setOutputVolume(play_card,play_stream,play_port,0+play_cut_gain);
    play_cae->positionPlay(play_handle,q->value(1).toUInt());
    play_cae->play(play_handle,q->value(2).toUInt()-q->value(1).toUInt(),
		   1000,false);
    play_cae->
      setPlayPortActive(play_card,play_port,play_stream);
  }
  delete q;
}


void RDSimplePlayer::stop()
{
  if(!play_is_playing) {
    return;
  }
  play_cae->stopPlay(play_handle);
}


void RDSimplePlayer::playingData(int handle)
{
  if(handle!=play_handle) {
    return;
  }
  play_event_player->exec(play_start_cart);
  play_start_button->on();
  play_stop_button->off();
  play_is_playing=true;
}


void RDSimplePlayer::playStoppedData(int handle)
{
  if(handle!=play_handle) {
    return;
  }
  play_cae->unloadPlay(play_handle);
}


void RDSimplePlayer::playUnloadedData(int handle)
{
  if(handle!=play_handle) {
    return;
  }
  play_event_player->exec(play_end_cart);
  play_start_button->off();
  play_stop_button->on();
  play_handle=-1;
  play_is_playing=false;
}
