// rddeck.cpp
//
// Abstract a Rivendell Deck.
//
//   (C) Copyright 2002-2003 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rddeck.cpp,v 1.12 2007/09/14 14:06:24 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <rdconf.h>
#include <rddeck.h>


//
// Global Classes
//
RDDeck::RDDeck(QString station,unsigned channel,bool create)
{
  QSqlQuery *q;
  QString sql;

  deck_station=station;
  deck_channel=channel;

  if(create) {
    sql=QString().sprintf("select ID from DECKS where \
(STATION_NAME=\"%s\")&&(CHANNEL=%d)",(const char *)deck_station,deck_channel);
    q=new QSqlQuery(sql);
    if(q->size()!=1) {
      delete q;
      sql=QString().
        sprintf("INSERT INTO DECKS SET STATION_NAME=\"%s\",CHANNEL=%d",
		(const char *)deck_station,deck_channel);
      q=new QSqlQuery(sql);
      delete q;
    }
    else {
      delete q;
    }
  }
}


QString RDDeck::station() const
{
  return deck_station;
}


int RDDeck::channel() const
{
  return deck_channel;
}


int RDDeck::cardNumber()
{
  return GetIntValue("CARD_NUMBER");
}


void RDDeck::setCardNumber(int card)
{
  SetRow("CARD_NUMBER",card);
}


int RDDeck::streamNumber()
{
  return GetIntValue("STREAM_NUMBER");
}


void RDDeck::setStreamNumber(int stream)
{
  SetRow("STREAM_NUMBER",stream);
}


int RDDeck::portNumber()
{
  return GetIntValue("PORT_NUMBER");
}


void RDDeck::setPortNumber(int port)
{
  SetRow("PORT_NUMBER",port);
}


int RDDeck::monitorPortNumber()
{
  return GetIntValue("MON_PORT_NUMBER");
}


void RDDeck::setMonitorPortNumber(int port)
{
  SetRow("MON_PORT_NUMBER",port);
}


bool RDDeck::defaultMonitorOn()
{
  return RDBool(GetStringValue("DEFAULT_MONITOR_ON"));
}


void RDDeck::setDefaultMonitorOn(bool state)
{
  SetRow("DEFAULT_MONITOR_ON",state);
}


RDSettings::Format RDDeck::defaultFormat()
{
  return (RDSettings::Format)GetIntValue("DEFAULT_FORMAT");
}


void RDDeck::setDefaultFormat(RDSettings::Format format)
{
  SetRow("DEFAULT_FORMAT",(int)format);
}


int RDDeck::defaultChannels()
{
  return GetIntValue("DEFAULT_CHANNELS");
}


void RDDeck::setDefaultChannels(int chan)
{
  SetRow("DEFAULT_CHANNELS",chan);
}


int RDDeck::defaultSamprate()
{
  return GetIntValue("DEFAULT_SAMPRATE");
}


void RDDeck::setDefaultSamprate(int rate)
{
  SetRow("DEFAULT_SAMPRATE",rate);
}


int RDDeck::defaultBitrate()
{
  return GetIntValue("DEFAULT_BITRATE");
}


void RDDeck::setDefaultBitrate(int rate)
{
  SetRow("DEFAULT_BITRATE",rate);
}


int RDDeck::defaultThreshold()
{
  return GetIntValue("DEFAULT_THRESHOLD");
}


void RDDeck::setDefaultThreshold(int level)
{
  SetRow("DEFAULT_THRESHOLD",level);
}


QString RDDeck::switchStation()
{
  return GetStringValue("SWITCH_STATION");
}


void RDDeck::setSwitchStation(QString str)
{
  SetRow("SWITCH_STATION",str);
}


int RDDeck::switchMatrix()
{
  return GetIntValue("SWITCH_MATRIX");
}


QString RDDeck::switchMatrixName()
{
  QString matrix_name;

  QSqlQuery *q=new QSqlQuery(QString().sprintf("select NAME from MATRICES \
                             where (STATION_NAME=\"%s\")&&(MATRIX=%d)",
					       (const char *)switchStation(),
					       switchMatrix()));
  if(q->first()) {
    matrix_name=q->value(0).toString();
  }
  delete q;
  return matrix_name;
}


void RDDeck::setSwitchMatrix(int matrix)
{
  SetRow("SWITCH_MATRIX",matrix);
}


int RDDeck::switchOutput()
{
  return GetIntValue("SWITCH_OUTPUT");
}


QString RDDeck::switchOutputName()
{
  QString output_name;

  QSqlQuery *q=new QSqlQuery(QString().sprintf("select NAME from OUTPUTS \
                             where (STATION_NAME=\"%s\")&&(MATRIX=%d)&&\
                                   (NUMBER=%d)",
					       (const char *)switchStation(),
					       switchMatrix(),
					       switchOutput()));
  if(q->first()) {
    output_name=q->value(0).toString();
  }
  delete q;
  return output_name;
}


void RDDeck::setSwitchOutput(int output)
{
  SetRow("SWITCH_OUTPUT",output);
}


int RDDeck::switchDelay()
{
  return GetIntValue("SWITCH_DELAY");
}


void RDDeck::setSwitchDelay(int delay)
{
  SetRow("SWITCH_DELAY",delay);
}


int RDDeck::GetIntValue(QString field)
{
  QString sql;
  QSqlQuery *q;
  int accum;
  
  sql=QString().sprintf("select %s from DECKS where \
(STATION_NAME=\"%s\")&&(CHANNEL=%d)",(const char *)field,
			(const char *)deck_station,deck_channel);
  q=new QSqlQuery(sql);
  if(q->first()) {
    accum=q->value(0).toInt();
    delete q;
    return accum;
  }
  delete q;
  return 0;    
}


QString RDDeck::GetStringValue(QString field)
{
  QString sql;
  QSqlQuery *q;
  QString accum;
  
  sql=QString().sprintf("select %s from DECKS where \
(STATION_NAME=\"%s\")&&(CHANNEL=%d)",(const char *)field,
			(const char *)deck_station,deck_channel);
  q=new QSqlQuery(sql);
  if(q->first()) {
    accum=q->value(0).toString();
    delete q;
    return accum;
  }
  delete q;
  return 0;    
}


void RDDeck::SetRow(QString param,int value)
{
  QSqlQuery *q;
  QString sql;

  sql=QString().sprintf("UPDATE DECKS SET %s=%d \
WHERE (STATION_NAME=\"%s\")&&(CHANNEL=%d)",
			(const char *)param,
			value,
			(const char *)deck_station,
			deck_channel);
  q=new QSqlQuery(sql);
  delete q;
}


void RDDeck::SetRow(QString param,QString value)
{
  QSqlQuery *q;
  QString sql;

  sql=QString().sprintf("UPDATE DECKS SET %s=\"%s\" \
WHERE (STATION_NAME=\"%s\")&&(CHANNEL=%d)",
			(const char *)param,
			(const char *)value,
			(const char *)deck_station,
			deck_channel);
  q=new QSqlQuery(sql);
  delete q;
}


void RDDeck::SetRow(QString param,bool value)
{
  QSqlQuery *q;
  QString sql;

  sql=QString().sprintf("UPDATE DECKS SET %s=\"%s\" \
WHERE (STATION_NAME=\"%s\")&&(CHANNEL=%d)",
			(const char *)param,
			(const char *)RDYesNo(value),
			(const char *)deck_station,
			deck_channel);
  q=new QSqlQuery(sql);
  delete q;
}


