// rdcart_dialog.h
//
// A widget to select a Rivendell Cart.
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdcart_dialog.h,v 1.13 2007/02/14 21:48:41 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef RDCART_DIALOG_H
#define RDCART_DIALOG_H

#include <qdialog.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <rdlistviewitem.h>
#include <rdcart.h>
#include <rdstation.h>
#include <rdcombobox.h>


class RDCartDialog : public QDialog
{
 Q_OBJECT
 public:
 RDCartDialog(int *cartnum,QString *filter,QString *group,
	      RDCart::Type type,QString *svcname,int svc_quan,
	      QWidget *parent=0,const char *name=0);
 ~RDCartDialog();
 QSize sizeHint() const;
 QSizePolicy sizePolicy() const;

 private slots:
  void filterChangedData(const QString &);
  void filterClearedData();
  void groupActivatedData(const QString &);
  void doubleClickedData(QListViewItem *,const QPoint &,int);
  void okData();
  void cancelData();

 protected:
  void closeEvent(QCloseEvent *e);

 private:
  void RefreshCarts();
  void BuildGroupList();
  QString GetSearchFilter(QString filter,QString group);
  int *cart_cartnum;
  RDListView *cart_cart_list;
  QLineEdit *cart_filter_edit;
  QPushButton *cart_clear_button;
  RDComboBox *cart_group_box;
  QString *cart_filter;
  QString *cart_group;
  bool local_filter;
  RDCart::Type cart_type;
  QPixmap *cart_playout_map;
  QPixmap *cart_macro_map;
  QString *cart_service;
  int cart_service_quan;
};


#endif
