// edit_feed.h
//
// Edit a Rivendell Feed
//
//   (C) Copyright 2002-2007 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: edit_feed.h,v 1.4 2007/11/29 19:29:19 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef EDIT_FEED_H
#define EDIT_FEED_H

#include <qdialog.h>
#include <qtextedit.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qsqldatabase.h>
#include <qcheckbox.h>
#include <qlabel.h>

#include <rdfeed.h>
#include <rdsettings.h>
#include <rdstation.h>


class EditFeed : public QDialog
{
 Q_OBJECT
 public:
  EditFeed(const QString &name,QWidget *parent=0,const char *name=0);
  QSize sizeHint() const;
  QSizePolicy sizePolicy() const;

 private slots:
  void purgeUrlChangedData(const QString &str);
  void purgeUsernameChangedData(const QString &username);
  void setFormatData();
  void normalizeCheckData(bool state);
  void editData();
  void okData();
  void cancelData();
  
 protected:
  void paintEvent(QPaintEvent *e);

 private:
  RDFeed *feed_feed;
  QLineEdit *feed_keyname_edit;
  QLineEdit *feed_channel_title_edit;
  QTextEdit *feed_channel_description_edit;
  QLineEdit *feed_channel_category_edit;
  QLineEdit *feed_channel_link_edit;
  QLineEdit *feed_channel_copyright_edit;
  QLineEdit *feed_channel_webmaster_edit;
  QLineEdit *feed_channel_language_edit;
  QLineEdit *feed_base_url_edit;
  QLineEdit *feed_purge_url_edit;
  QLabel *feed_purge_username_label;
  QLineEdit *feed_purge_username_edit;
  QLabel *feed_purge_password_label;
  QLineEdit *feed_purge_password_edit;
  QTextEdit *feed_header_xml_edit;
  QTextEdit *feed_channel_xml_edit;
  QTextEdit *feed_item_xml_edit;
  QSpinBox *feed_max_shelf_life_spin;
  QCheckBox *feed_autopost_box;
  QCheckBox *feed_keep_metadata_box;
  RDSettings feed_settings;
  QLineEdit *feed_format_edit;
  QCheckBox *feed_normalize_box;
  QLabel *feed_normalize_label;
  QSpinBox *feed_normalize_spin;
  QLabel *feed_normalize_unit;
};


#endif  // EDIT_FEED_H

