// edit_gpi.cpp
//
// Edit a Rivendell Gpi
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: edit_gpi.cpp,v 1.14 2007/12/31 18:49:08 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qmessagebox.h>

#include <rdcart_dialog.h>
#include <rdtextvalidator.h>

#include <globals.h>
#include <edit_gpi.h>


EditGpi::EditGpi(int gpi,int *cart,QString *desc,
		 QWidget *parent,const char *name)
  : QDialog(parent,name,true)
{
  QString str;

  edit_gpi=gpi;
  edit_cart=cart;
  edit_description=desc;
  str=QString(tr("Edit GPI"));
  setCaption(QString().sprintf("%s %d",(const char *)str,gpi));

  //
  // Fix the Window Size
  //
  setMinimumWidth(sizeHint().width());
  setMaximumWidth(sizeHint().width());
  setMinimumHeight(sizeHint().height());
  setMaximumHeight(sizeHint().height());

  //
  // Create Fonts
  //
  QFont bold_font=QFont("Helvetica",12,QFont::Bold);
  bold_font.setPixelSize(12);
  QFont font=QFont("Helvetica",12,QFont::Normal);
  font.setPixelSize(12);

  //
  // Text Validator
  //
  RDTextValidator *validator=new RDTextValidator(this,"validator");

  //
  // Gpi Number
  //
  QLabel *label=
    new QLabel(QString().sprintf("%d",edit_gpi),this,"edit_endpoint_num");
  label->setGeometry(120,10,60,20);
  label->setFont(font);
  label=new QLabel(tr("GPI: "),this,"edit_endpoint_label");
  label->setGeometry(10,10,105,20);
  label->setFont(bold_font);
  label->setAlignment(AlignRight|AlignVCenter);

  //
  // Cart Description
  //
  edit_description_edit=new QLineEdit(this,"edit_description_edit");
  edit_description_edit->setGeometry(120,35,sizeHint().width()-130,20);
  edit_description_edit->setFont(font);
  edit_description_edit->setReadOnly(true);
  label=new QLabel(tr("Description: "),this,"edit_description_label");
  label->setGeometry(10,35,105,20);
  label->setFont(bold_font);
  label->setAlignment(AlignRight|AlignVCenter);

  //
  // Cart Macro Cart
  //
  edit_macro_edit=new QLineEdit(this,"edit_macro_edit");
  edit_macro_edit->setGeometry(120,59,60,20);
  edit_macro_edit->setFont(font);
  edit_macro_edit->setValidator(validator);
  label=new QLabel(tr("Cart Number: "),this,"edit_macro_label");
  label->setGeometry(10,59,105,20);
  label->setFont(bold_font);
  label->setAlignment(AlignRight|AlignVCenter);

  //
  // Select Button
  //
  QPushButton *button=new QPushButton(this,"select_button");
  button->setGeometry(190,59,60,20);
  button->setFont(font);
  button->setText(tr("&Select"));
  connect(button,SIGNAL(clicked()),this,SLOT(selectData()));

  //
  // Clear Button
  //
  button=new QPushButton(this,"select_button");
  button->setGeometry(270,59,60,20);
  button->setFont(font);
  button->setText(tr("C&lear"));
  connect(button,SIGNAL(clicked()),this,SLOT(clearData()));

  //
  //  Ok Button
  //
  button=new QPushButton(this,"ok_button");
  button->setGeometry(sizeHint().width()-180,sizeHint().height()-60,80,50);
  button->setDefault(true);
  button->setFont(bold_font);
  button->setText(tr("&OK"));
  connect(button,SIGNAL(clicked()),this,SLOT(okData()));

  //
  //  Cancel Button
  //
  button=new QPushButton(this,"cancel_button");
  button->setGeometry(sizeHint().width()-90,sizeHint().height()-60,
			     80,50);
  button->setFont(bold_font);
  button->setText(tr("&Cancel"));
  connect(button,SIGNAL(clicked()),this,SLOT(cancelData()));

  //
  // Load Data
  //
  if(*edit_cart>0) {
    RDCart *rdcart=new RDCart(*cart);
    edit_macro_edit->setText(QString().sprintf("%06d",*cart));
    edit_description_edit->setText(rdcart->title());
    delete rdcart;
  }
}


QSize EditGpi::sizeHint() const
{
  return QSize(420,160);
}


QSizePolicy EditGpi::sizePolicy() const
{
  return QSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
}


void EditGpi::selectData()
{
  int cart=edit_macro_edit->text().toInt();
  if(admin_cart_dialog->exec(&cart,RDCart::Macro,NULL,0)==0) {
    if(cart>0) {
      RDCart *rdcart=new RDCart(cart);
      edit_macro_edit->setText(QString().sprintf("%06d",cart));
      edit_description_edit->setText(rdcart->title());
      delete rdcart;
    }
    else {
      edit_macro_edit->setText("");
      edit_description_edit->clear();
    }
  }
}


void EditGpi::clearData()
{
  edit_description_edit->clear();
  edit_macro_edit->clear();
}


void EditGpi::okData()
{
  bool ok;
  if(!edit_macro_edit->text().isEmpty()) {
    int cart=edit_macro_edit->text().toInt(&ok);
    if(ok) {
      *edit_cart=cart;
      RDCart *rdcart=new RDCart(cart);
      *edit_description=rdcart->title();
      delete rdcart;
      done(0);
    }
    else {
      QMessageBox::warning(this,tr("Invalid Cart"),tr("Invalid Cart Number!"));
    }
  }
  else {
    *edit_cart=-1;
    *edit_description="";
    done(0);
  }
}


void EditGpi::cancelData()
{
  done(-1);
}
