// rdgroup.h
//
// Abstract a Rivendell Service
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rdgroup.h,v 1.13 2007-02-14 21:48:41 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qsqldatabase.h>
#include <qcolor.h>

#include <rdcart.h>

#ifndef RDGROUP_H
#define RDGROUP_H

class RDGroup
{
 public:
  enum ExportType {None=0,Traffic=1,Music=2};
  RDGroup(QString name,bool create=false,QSqlDatabase *db=0);
  QString name() const;
  bool exists() const;
  QString description() const;
  void setDescription(const QString &desc) const;
  RDCart::Type defaultCartType() const;
  void setDefaultCartType(RDCart::Type type) const;
  unsigned defaultLowCart() const;
  void setDefaultLowCart(unsigned cartnum) const;
  unsigned defaultHighCart() const;
  void setDefaultHighCart(unsigned cartnum) const;
  bool enforceCartRange() const;
  void setEnforceCartRange(bool state) const;
  bool exportReport(ExportType type) const;
  void setExportReport(ExportType type,bool state) const;
  bool enableNowNext() const;
  void setEnableNowNext(bool state) const;
  QColor color() const;
  void setColor(const QColor &color);
  unsigned nextFreeCart(unsigned startcart=0) const;
  int freeCartQuantity() const;
  bool cartNumberValid(unsigned cartnum) const;
  
 private:
  void SetRow(const QString &param,unsigned value) const;
  void SetRow(const QString &param,const QString &value) const;
  QString ReportField(ExportType type) const;
  QSqlDatabase *group_db;
  QString group_name;
};


#endif 
