// rddeck.h
//
// Abstract a Rivendell Record/Play Deck
//
//   (C) Copyright 2002-2004 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: rddeck.h,v 1.16 2008-08-04 19:05:32 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qsqldatabase.h>
#include <qtimer.h>

#include <rdsettings.h>

#ifndef RDDECK_H
#define RDDECK_H

class RDDeck
{
  public:
   enum Status {Offline=0,Idle=1,Ready=2,Recording=3,Waiting=4};
   RDDeck(QString station,unsigned channel,bool create=false);
   QString station() const;
   int channel() const;
   int cardNumber();
   void setCardNumber(int card);
   int streamNumber();
   void setStreamNumber(int stream);
   int portNumber();
   void setPortNumber(int port);
   int monitorPortNumber();
   void setMonitorPortNumber(int port);
   bool defaultMonitorOn();
   void setDefaultMonitorOn(bool state);
   RDSettings::Format defaultFormat();
   void setDefaultFormat(RDSettings::Format format);
   int defaultChannels();
   void setDefaultChannels(int chan);
   int defaultSamprate();
   void setDefaultSamprate(int rate);
   int defaultBitrate();
   void setDefaultBitrate(int rate);
   int defaultThreshold();
   void setDefaultThreshold(int level);
   QString switchStation();
   void setSwitchStation(QString str);
   int switchMatrix();
   QString switchMatrixName();
   void setSwitchMatrix(int matrix);
   int switchOutput();
   QString switchOutputName();
   void setSwitchOutput(int output);
   int switchDelay();
   void setSwitchDelay(int delay);

  private:
   int GetIntValue(const QString &field);
   QString GetStringValue(const QString &field);
   void SetRow(const QString &param,int value);
   void SetRow(const QString &param,const QString &value);
   void SetRow(const QString &param,bool value);
   int deck_channel;
   QString deck_station;
};


#endif 
