// edit_hot_keys.cpp
//
// Edit the Hot Key Configuration for a Rivendell Workstation.
//

#include <qsignalmapper.h>
#include <qdialog.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qsqldatabase.h>
#include <qmessagebox.h>
#include <qlistbox.h>
#include <rdhotkeylist.h>
#include <edit_rdairplay_hotkeys.h>
#include <globals.h>


   //EditNowNext(RDAirPlayConf *conf,QWidget *parent=0,const char *name=0);
EditRdAirplayHotKeys::EditRdAirplayHotKeys(const QString &station,QWidget *parent,const char *name)
  : QDialog(parent,name,true)
{
    QString sql;
    RDSqlQuery *q;

    hotkey_conf=station;
    station_hotkeys= new RDAirplay_Hotkeys(hotkey_conf);
    myhotkeylist = new RDHotKeyList();
   // RDHotKeyList ahotkeylist = new RDHotKeyList(&hotkeylistptr);
    //
    // Create Fonts
    //
    QFont normal_font=QFont("Helvetica",12,QFont::Normal);
    normal_font.setPixelSize(12);
    QFont font=QFont("Helvetica",12,QFont::Bold);
    font.setPixelSize(12);
    QFont section_font=QFont("Helvetica",14,QFont::Bold);
    section_font.setPixelSize(14);

    //
    // Fix the Window Size
    //
    setMinimumWidth(sizeHint().width());
    setMaximumWidth(sizeHint().width());
    setMinimumHeight(sizeHint().height());
    setMaximumHeight(sizeHint().height());

    //
    // Hot Key Configuration Label
    //
    setCaption(tr("Hot Key Configuration for ")+hotkey_conf);

    list_view=new QListView(this,"list_view");
    list_view->setGeometry(10,24,320,220);
    QLabel *label=new QLabel(list_view,tr("Host Hot Key Configurations"),
                       this,"list_view_label");
    label->setFont(font);
    label->setGeometry(14,5,sizeHint().width()-28,19);
    //list_view->setItemMargin(5);
    list_view->setSorting(-1);
    list_view->addColumn(tr("Button / Function "));
    list_view->setColumnAlignment(0,AlignLeft|AlignVCenter);
    list_view->addColumn(tr("KeyStroke"));
    list_view->setColumnAlignment(1,AlignLeft|AlignVCenter);
    list_view->setAllColumnsShowFocus(true);
 
    connect(list_view,SIGNAL(clicked(QListViewItem *,const QPoint &,int)),
                 this,SLOT(showCurrentKey()));
    connect(list_view,SIGNAL(doubleClicked(QListViewItem *,const QPoint &,int)),
                 this,SLOT(showCurrentKey()));



    //  Keystroke Value field
    keystroke = new QLineEdit(this);
    keystroke->setFocusPolicy(QWidget::StrongFocus);
    keystroke->setGeometry(sizeHint().width()-270,sizeHint().height()-210,200,35);
  
  
    // Set Button
    //
    QPushButton *set_button = new QPushButton(this,"set_button");
    set_button->setGeometry(sizeHint().width()-290,sizeHint().height()-160,60,30);
    set_button->setDefault(true);
    set_button->setFont(font);
    set_button->setText(tr("Set"));
    connect(set_button,SIGNAL(clicked()), this, SLOT(SetButtonClicked()) );
  
    // Clear Button
    //
    QPushButton *clear_button = new QPushButton(this,"clear_button");
    clear_button->setGeometry(sizeHint().width()-215,sizeHint().height()-160,60,30);
    clear_button->setDefault(true);
    clear_button->setFont(font);
    clear_button->setText(tr("Clear"));
    connect(clear_button,SIGNAL(clicked()), this, SLOT(clearCurrentItem()) );
  
    // Clear All Hot Keys Button
    //
    QPushButton *clear_all_button = new QPushButton(this,"clear_all_button");
    clear_all_button->setGeometry(sizeHint().width()-140,sizeHint().height()-160,130,30);
    clear_all_button->setDefault(true);
    clear_all_button->setFont(font);
    clear_all_button->setText(tr("Clear All Hotkeys"));
    connect(clear_all_button,SIGNAL(clicked()), this,SLOT(clearAll_Hotkeys()) );
  
    // Clone Host Drop Box
    //
    clone_from_host_box=new QComboBox(this,"clone_from_host_box");
    clone_from_host_box->setGeometry(sizeHint().width()-295,sizeHint().height()-110,130,30);
    clone_from_host_label=new QLabel(clone_from_host_box,tr("Set From Host:"),
                               this,"clone_from_host_label");
    clone_from_host_label->setFont(font);
    clone_from_host_label->setGeometry(sizeHint().width()-420,sizeHint().height()-110,120,30);
    clone_from_host_label->setAlignment(AlignRight|AlignVCenter);
    sql=QString().sprintf("select NAME from STATIONS");
    q=new RDSqlQuery(sql);
    while(q->next()) {
        clone_from_host_box->insertItem(q->value(0).toString());
        if (hotkey_conf == q->value(0).toString()) {
            clone_from_host_box->setCurrentItem(clone_from_host_box->count()-1);
            current_station_clone_item = clone_from_host_box->count()-1;
        }
    }
    delete q;
    connect (clone_from_host_box,SIGNAL(activated(const QString&)),
             this,SLOT(Clone_RefreshList(const QString&))); 
 
    //
    //  Save Button
    //
    QPushButton *save_button=new QPushButton(this,"save_button");
    save_button->setGeometry(sizeHint().width()-180,sizeHint().height()-60,80,50);
    save_button->setDefault(true);
    save_button->setFont(font);
    save_button->setText(tr("Save"));
    connect(save_button,SIGNAL(clicked()),this,SLOT(save()));
  
    //
    //  Cancel Button
    //
    QPushButton *cancel_button=new QPushButton(this,"cancel_button");
    cancel_button->setGeometry(sizeHint().width()-90,sizeHint().height()-60,
                               80,50);
    cancel_button->setFont(font);
    cancel_button->setText(tr("Cancel"));
  
  
    connect(cancel_button,SIGNAL(clicked()),this,SLOT(cancel()));
  
    keystrokecount=0;
    AltKeyHit  = false;
    CtrlKeyHit = false;

  
    RefreshList();

}


EditRdAirplayHotKeys::~EditRdAirplayHotKeys()
{
}


QSize EditRdAirplayHotKeys::sizeHint() const
{
  return QSize(400,500);
} 


QSizePolicy EditRdAirplayHotKeys::sizePolicy() const
{
  return QSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
}

void EditRdAirplayHotKeys::save()
{

    QListViewItemIterator  *start;

    start = new QListViewItemIterator(list_view);

    QString stringlist [40][45];   //  assumes no more than 40 entries...
    int cur, top, i = 0;
    while (start->current()) {
        if (start->current()->text(1).isEmpty())  {
            stringlist[i++][0] = QString("");
        }
        else  {
            stringlist[i++][0] = QString().sprintf("%s",
                  (const char *) start->current()->text(1));
        }
    ++(*start);
    }
    delete start;

    for ( top = 0; top < (i- 1) ; top++)  {
        for (cur = top + 1; cur < i; cur ++) {
            if ( (strcmp(stringlist[top][0],stringlist[cur][0]) == 0)  &&
                 (!(stringlist[top][0].isEmpty()) ) ){
                QString str = tr(QString().sprintf( \
                    "Duplicate Hotkey defined %s\n No Duplicates allowed.",
                             (const char *)stringlist[cur][0] ));
                QMessageBox::warning(this,tr("Duplicate Entries"),str);
                return;
            }
        }
    }

    // Do the seven Start/Stop/Pause Lines
    top = 1;       

    for (cur = 0; cur < 19; cur+=3)  {
        station_hotkeys->setplay_hotkey(top,stringlist[cur][0]);
        station_hotkeys->setstop_hotkey(top,stringlist[cur+1][0]);
        station_hotkeys->setpause_hotkey(top,stringlist[cur+2][0]);
        top++;
    }
    
    station_hotkeys->setadd_hotkey(stringlist[cur++][0]);
    station_hotkeys->setdel_hotkey(stringlist[cur++][0]);
    station_hotkeys->setcopy_hotkey(stringlist[cur++][0]);
    station_hotkeys->setmove_hotkey(stringlist[cur++][0]);
    station_hotkeys->setsoundpanel_hotkey(stringlist[cur++][0]);
    station_hotkeys->setmainlog_hotkey(stringlist[cur++][0]);
    station_hotkeys->setauxlog_hotkey(1,stringlist[cur++][0]);
    station_hotkeys->setauxlog_hotkey(2,stringlist[cur++][0]);
    delete station_hotkeys;
    done(0);
}

void EditRdAirplayHotKeys::SetHotKey()
{

    QListViewItem *item=list_view->selectedItem();
    if (item==NULL) return;

    item->setText(1,hotkeystrokes);
    keyupdated = true;
}

void EditRdAirplayHotKeys::clearAll_Hotkeys()
{
    switch(QMessageBox::warning(this,tr("Hotkeys Clear"),
                   "Are you sure - This will Clear All Hot Key Settings!",
                         QMessageBox::Yes,QMessageBox::No)) {
        case QMessageBox::No:
        case QMessageBox::NoButton:
            return;
        default:
            break;
    }
    
    QListViewItem *l = list_view->firstChild();
    while (l)  {
        l->setText(1,"");
        l = l->nextSibling();
    }
    keystroke->setText("");
    keystroke->setFocus();
    hotkeystrokes=QString("");
    keystrokecount=0;
    keyupdated = true;
}
 


void EditRdAirplayHotKeys::cancel()
{
    if (keyupdated) {
        switch(QMessageBox::warning(this,tr("Hotkeys Updated"),
                       "Are you sure - All Hot Keys changes will be Lost!",
                              QMessageBox::Yes,QMessageBox::No)) {
        case QMessageBox::No:
        case QMessageBox::NoButton:
            return;
        default:
            break;
        }
    }
    close();
}

void EditRdAirplayHotKeys::keyPressEvent (QKeyEvent *e)
{
    if ( (e->key() == Qt::Key_Backspace) ||
         (e->key() == Qt::Key_Delete) )    {
        keystroke->setText("");
        keystroke->setFocus();
        hotkeystrokes=QString("");
        keystrokecount=0;
        return;
    }

    if (e->key() == Qt::Key_Alt)  {
        keystrokecount++;
        AltKeyHit = true;
    }

    if (e->key() == Qt::Key_Control)  {
        keystrokecount++;
        CtrlKeyHit = true;
    }

}

void EditRdAirplayHotKeys::keyReleaseEvent (QKeyEvent *e)
{
    int keyhit = e->key();
    QString mystring=(*myhotkeylist).GetKeyCode(keyhit);

    if (mystring.length() == 0 ) {        // should never happen unless shell got it...
        keystroke->setFocus();
        keystroke->setText("");
        hotkeystrokes=QString("");
        keystrokecount = 0;
        AltKeyHit = false;
        CtrlKeyHit = false;
        return;
    }

    if ( (e->key() == Qt::Key_Backspace) ||
         (e->key() == Qt::Key_Space) ||
         (e->key() == Qt::Key_Delete) )    {
         keystroke->setFocus();
         keystroke->setText("");
         hotkeystrokes=QString("");
         keystrokecount = 0;
         return;
    }

    if (e->key() == Qt::Key_Shift) {
        QWidget::keyReleaseEvent(e);
        return;
    }

    if ( (e->key() == Qt::Key_Up) || (e->key() == Qt::Key_Left) ||
         (e->key() == Qt::Key_Right) || (e->key() == Qt::Key_Down) )    {
        QWidget::keyReleaseEvent(e);
        keystrokecount = 0;
        hotkeystrokes = QString ("");
        keystroke->setText("");
        return;
    }

    if ( (e->key() == Qt::Key_Tab)  || (e->key() == Qt::Key_Left) ||
         (e->key() == Qt::Key_Right) ){
        QWidget::keyReleaseEvent(e);
        keystrokecount = 0;
        hotkeystrokes = QString ("");
        keystroke->setText("");
        return;
    }

    if ((e->key() == Qt::Key_Alt) ||
        (e->key() == Qt::Key_Control)) {
        if (keystrokecount != 0 ) hotkeystrokes = QString ("");
        if (AltKeyHit) {
            AltKeyHit = false;
            if (keystrokecount > 0) keystrokecount--;
        }
        if (CtrlKeyHit) {
            CtrlKeyHit = false;
            if (keystrokecount > 0) keystrokecount--;
            }
        keystroke->setText(QString().sprintf("%s",(const char *)hotkeystrokes));
        return;
    }
    if (keystrokecount > 2)  {
        keystroke->setText(QString().sprintf("%s",(const char *)hotkeystrokes));
        return;
    }

    if (!e->isAutoRepeat()) {
        if (keystrokecount == 0)
            hotkeystrokes = QString ("");
        if (AltKeyHit) {
            hotkeystrokes =  (*myhotkeylist).GetKeyCode(Qt::Key_Alt);
            hotkeystrokes +=  QString(" + ");
        }
        if (CtrlKeyHit) {
            if (AltKeyHit) {
                hotkeystrokes +=  (*myhotkeylist).GetKeyCode(Qt::Key_Control);
                hotkeystrokes += QString (" + ");
            }
            else {
                hotkeystrokes =  (*myhotkeylist).GetKeyCode(Qt::Key_Control);
                hotkeystrokes += QString (" + ");
            }
        }

        hotkeystrokes += mystring;
        keystroke->setText(QString().sprintf("%s",(const char *)hotkeystrokes));
        keystrokecount = 0;
        return;
    }
}

void EditRdAirplayHotKeys::RefreshList()
{

    station_hotkeys= new RDAirplay_Hotkeys(hotkey_conf);

    QListViewItem *l;
    list_view->clear();
  
    keyupdated = false;

    //  Build Rows of List View  I do this in reverse...

    //  aux log row 1
    l=new QListViewItem(list_view);
    l->setText(0,tr("Aux Log 2"));
    QString auxlog_keystroke2= station_hotkeys->auxlog_hotkey(2);
    l->setText(1,auxlog_keystroke2);

    //  aux log row 2
    l=new QListViewItem(list_view);
    l->setText(0,tr("Aux Log 1"));
    QString auxlog_keystroke1= station_hotkeys->auxlog_hotkey(1);
    l->setText(1,auxlog_keystroke1);

    //  main log row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Main Log"));
    QString mainlog_keystroke= station_hotkeys->mainlog_hotkey();
    l->setText(1,mainlog_keystroke);

    //  sound panel row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Sound Panel"));
    QString soundpanel_keystroke= station_hotkeys->soundpanel_hotkey();
    l->setText(1,soundpanel_keystroke);

    //  move row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Move"));
    QString move_keystroke= station_hotkeys->move_hotkey();
    l->setText(1,move_keystroke);

    //  copy row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Copy"));
    QString copy_keystroke= station_hotkeys->copy_hotkey();
    l->setText(1,copy_keystroke);

    //  delete row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Delete"));
    QString del_keystroke= station_hotkeys->del_hotkey();
    l->setText(1,del_keystroke);

    //  add row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Add"));
    QString add_keystroke= station_hotkeys->add_hotkey();
    l->setText(1,add_keystroke);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 7"));
    QString pause_keystroke7= station_hotkeys->pause_hotkey(7);
    l->setText(1,pause_keystroke7);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 7"));
    QString stop_keystroke7= station_hotkeys->stop_hotkey(7);
    l->setText(1,stop_keystroke7);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 7"));
    QString play_keystroke7=station_hotkeys->play_hotkey(7);
    l->setText(1,play_keystroke7);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 6"));
    QString pause_keystroke6= station_hotkeys->pause_hotkey(6);
    l->setText(1,pause_keystroke6);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 6"));
    QString stop_keystroke6= station_hotkeys->stop_hotkey(6);
    l->setText(1,stop_keystroke6);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 6"));
    QString play_keystroke6=station_hotkeys->play_hotkey(6);
    l->setText(1,play_keystroke6);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 5"));
    QString pause_keystroke5= station_hotkeys->pause_hotkey(5);
    l->setText(1,pause_keystroke5);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 5"));
    QString stop_keystroke5= station_hotkeys->stop_hotkey(5);
    l->setText(1,stop_keystroke5);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 5"));
    QString play_keystroke5=station_hotkeys->play_hotkey(5);
    l->setText(1,play_keystroke5);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 4"));
    QString pause_keystroke4= station_hotkeys->pause_hotkey(4);
    l->setText(1,pause_keystroke4);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 4"));
    QString stop_keystroke4= station_hotkeys->stop_hotkey(4);
    l->setText(1,stop_keystroke4);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 4"));
    QString play_keystroke4=station_hotkeys->play_hotkey(4);
    l->setText(1,play_keystroke4);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 3"));
    QString pause_keystroke3= station_hotkeys->pause_hotkey(3);
    l->setText(1,pause_keystroke3);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 3"));
    QString stop_keystroke3= station_hotkeys->stop_hotkey(3);
    l->setText(1,stop_keystroke3);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 3"));
    QString play_keystroke3=station_hotkeys->play_hotkey(3);
    l->setText(1,play_keystroke3);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 2"));
    QString pause_keystroke2= station_hotkeys->pause_hotkey(2);
    l->setText(1,pause_keystroke2);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 2"));
    QString stop_keystroke2= station_hotkeys->stop_hotkey(2);
    l->setText(1,stop_keystroke2);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 2"));
    QString play_keystroke2=station_hotkeys->play_hotkey(2);
    l->setText(1,play_keystroke2);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 1"));
    QString pause_keystroke1= station_hotkeys->pause_hotkey(1);
    l->setText(1,pause_keystroke1);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 1"));
    QString stop_keystroke1= station_hotkeys->stop_hotkey(1);
    l->setText(1,stop_keystroke1);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 1"));
    QString play_keystroke1=station_hotkeys->play_hotkey(1);
    l->setText(1,play_keystroke1);

    hotkeystrokes = QString ("");
    keystroke->setText(QString().sprintf("%s",(const char *)hotkeystrokes));
    clone_from_host_box->setCurrentItem(current_station_clone_item);

}

void EditRdAirplayHotKeys::Clone_RefreshList(const QString& clone_station)
{

    QString tmp_hotkey_conf = QString().sprintf("%s",
                                (const char *)clone_station);

    RDAirplay_Hotkeys *tmp_station_hotkeys= new RDAirplay_Hotkeys(tmp_hotkey_conf);
    keyupdated = true;
    QListViewItem *l;
    list_view->clear();
  
    //  aux log row 1
    l=new QListViewItem(list_view);
    l->setText(0,tr("Aux Log 2"));
    QString auxlog_keystroke2= tmp_station_hotkeys->auxlog_hotkey(2);
    l->setText(1,auxlog_keystroke2);

    //  aux log row 2
    l=new QListViewItem(list_view);
    l->setText(0,tr("Aux Log 1"));
    QString auxlog_keystroke1= tmp_station_hotkeys->auxlog_hotkey(1);
    l->setText(1,auxlog_keystroke1);

    //  main log row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Main Log"));
    QString mainlog_keystroke= tmp_station_hotkeys->mainlog_hotkey();
    l->setText(1,mainlog_keystroke);

    //  sound panel row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Sound Panel"));
    QString soundpanel_keystroke= tmp_station_hotkeys->soundpanel_hotkey();
    l->setText(1,soundpanel_keystroke);

    //  move row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Move"));
    QString move_keystroke= tmp_station_hotkeys->move_hotkey();
    l->setText(1,move_keystroke);

    //  copy row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Copy"));
    QString copy_keystroke= tmp_station_hotkeys->copy_hotkey();
    l->setText(1,copy_keystroke);

    //  delete row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Delete"));
    QString del_keystroke= tmp_station_hotkeys->del_hotkey();
    l->setText(1,del_keystroke);

    //  add row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Add"));
    QString add_keystroke= tmp_station_hotkeys->add_hotkey();
    l->setText(1,add_keystroke);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 7"));
    QString pause_keystroke7= tmp_station_hotkeys->pause_hotkey(7);
    l->setText(1,pause_keystroke7);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 7"));
    QString stop_keystroke7= tmp_station_hotkeys->stop_hotkey(7);
    l->setText(1,stop_keystroke7);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 7"));
    QString play_keystroke7=tmp_station_hotkeys->play_hotkey(7);
    l->setText(1,play_keystroke7);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 6"));
    QString pause_keystroke6= tmp_station_hotkeys->pause_hotkey(6);
    l->setText(1,pause_keystroke6);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 6"));
    QString stop_keystroke6= tmp_station_hotkeys->stop_hotkey(6);
    l->setText(1,stop_keystroke6);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 6"));
    QString play_keystroke6=tmp_station_hotkeys->play_hotkey(6);
    l->setText(1,play_keystroke6);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 5"));
    QString pause_keystroke5= tmp_station_hotkeys->pause_hotkey(5);
    l->setText(1,pause_keystroke5);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 5"));
    QString stop_keystroke5= tmp_station_hotkeys->stop_hotkey(5);
    l->setText(1,stop_keystroke5);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 5"));
    QString play_keystroke5=tmp_station_hotkeys->play_hotkey(5);
    l->setText(1,play_keystroke5);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 4"));
    QString pause_keystroke4= tmp_station_hotkeys->pause_hotkey(4);
    l->setText(1,pause_keystroke4);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 4"));
    QString stop_keystroke4= tmp_station_hotkeys->stop_hotkey(4);
    l->setText(1,stop_keystroke4);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 4"));
    QString play_keystroke4=tmp_station_hotkeys->play_hotkey(4);
    l->setText(1,play_keystroke4);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 3"));
    QString pause_keystroke3= tmp_station_hotkeys->pause_hotkey(3);
    l->setText(1,pause_keystroke3);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 3"));
    QString stop_keystroke3= tmp_station_hotkeys->stop_hotkey(3);
    l->setText(1,stop_keystroke3);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 3"));
    QString play_keystroke3=tmp_station_hotkeys->play_hotkey(3);
    l->setText(1,play_keystroke3);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 2"));
    QString pause_keystroke2= tmp_station_hotkeys->pause_hotkey(2);
    l->setText(1,pause_keystroke2);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 2"));
    QString stop_keystroke2= tmp_station_hotkeys->stop_hotkey(2);
    l->setText(1,stop_keystroke2);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 2"));
    QString play_keystroke2=tmp_station_hotkeys->play_hotkey(2);
    l->setText(1,play_keystroke2);

    //  pause row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Pause - Line 1"));
    QString pause_keystroke1= tmp_station_hotkeys->pause_hotkey(1);
    l->setText(1,pause_keystroke1);

    //  stop row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Stop - Line 1"));
    QString stop_keystroke1= tmp_station_hotkeys->stop_hotkey(1);
    l->setText(1,stop_keystroke1);

    // Play row
    l=new QListViewItem(list_view);
    l->setText(0,tr("Start - Line 1"));
    QString play_keystroke1=tmp_station_hotkeys->play_hotkey(1);
    l->setText(1,play_keystroke1);

    hotkeystrokes = QString ("");
    keystroke->setText(QString().sprintf("%s",(const char *)hotkeystrokes));
    delete tmp_station_hotkeys;
}

void EditRdAirplayHotKeys::showCurrentKey()
{
    QListViewItem *item=list_view->selectedItem();
    if (item==NULL) return;
    keystroke->setText((const char *)item->text(1));
    keystroke->displayText();
    hotkeystrokes=QString((const char *)item->text(1));
    return;
}


void EditRdAirplayHotKeys::clearCurrentItem()
{
    keystrokecount=0;
    keystroke->setText("");
    keystroke->setFocus();
    hotkeystrokes=QString("");
    return;
}

void EditRdAirplayHotKeys::SetButtonClicked()
{

    QListViewItem *item=list_view->selectedItem();
    if (item==NULL) {
        QMessageBox::warning(this,tr("No Items Selected"),
                         tr("Please Select an Item From the List"));
        return;
    }
    SetHotKey();
    return;
}

