// rdairplay_hotkeys.cpp
//
// Abstract an RDAirplay_HotKeys Configuration.
//
//
#include <rddb.h>
#include <rdconf.h>
#include <rdairplay_hotkeys.h>
#include <rdescape_string.h>

//
// Global Classes
//
RDAirplay_Hotkeys::RDAirplay_Hotkeys(const QString &station)
{
  QString sql;
  RDSqlQuery *q;
  
  station_hotkeys=station;

  sql=QString().sprintf(
      "select STATION_NAME from RDHOTKEYS where STATION_NAME=\"%s\" AND MODULE_NAME=\"airplay\"",
			(const char *)RDEscapeString(station_hotkeys));
  q=new RDSqlQuery(sql);

  if(!q->first()) {
    delete q;

    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=1,\
      KEY_LABEL=\"Start Line 1\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;

    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=2,\
      KEY_LABEL=\"Stop Line 1\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
     
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=3,\
      KEY_LABEL=\"Pause Line 1\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=4,\
      KEY_LABEL=\"Start Line 2\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=5,\
      KEY_LABEL=\"Stop Line 2\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=6,\
      KEY_LABEL=\"Pause Line 2\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
  
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=7,\
      KEY_LABEL=\"Start Line 3\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=8,\
      KEY_LABEL=\"Stop Line 3\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=9,\
      KEY_LABEL=\"Pause Line 3\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=10,\
      KEY_LABEL=\"Start Line 4\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=11,\
      KEY_LABEL=\"Stop Line 4\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=12,\
      KEY_LABEL=\"Pause Line 4\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=13,\
      KEY_LABEL=\"Start Line 5\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=14,\
      KEY_LABEL=\"Stop Line 5\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=15,\
      KEY_LABEL=\"Pause Line 5\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=16,\
      KEY_LABEL=\"Start Line 6\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
      
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=17,\
      KEY_LABEL=\"Stop Line 6\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=18,\
      KEY_LABEL=\"Pause Line 6\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=19,\
      KEY_LABEL=\"Start Line 7\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=20,\
      KEY_LABEL=\"Stop Line 7\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=21,\
      KEY_LABEL=\"Pause Line 7\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=22,\
      KEY_LABEL=\"Add\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=23,\
      KEY_LABEL=\"Delete\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=24,\
      KEY_LABEL=\"Copy\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=25,\
      KEY_LABEL=\"Move\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=26,\
      KEY_LABEL=\"Sound Panel\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=27,\
      KEY_LABEL=\"Main Log\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=28,\
      KEY_LABEL=\"Aux Log 1\" ",
      (const char *)station_hotkeys);
    q=new RDSqlQuery(sql);
    delete q;
 
    sql=QString().sprintf("insert into RDHOTKEYS set STATION_NAME=\"%s\",\
      MODULE_NAME=\"airplay\",\
      KEY_ID=29,\
      KEY_LABEL=\"Aux Log 2\" ",
      (const char *)station_hotkeys);

    q=new RDSqlQuery(sql);
  }
  delete q;
}


QString RDAirplay_Hotkeys::station() const
{
  return station_hotkeys;
}


QString RDAirplay_Hotkeys::play_hotkey(int num) const
{
  QString field=QString().sprintf("Start Line %d",num);
  return RDGetSqlValue("RDHOTKEYS",
                       "STATION_NAME",station_hotkeys,
                       "MODULE_NAME","airplay",
                       "KEY_LABEL",field,"KEY_VALUE").toString();
}

void RDAirplay_Hotkeys::setplay_hotkey(int num, QString value) const
{
  QString field=QString().sprintf("Start Line %d",num);
  SetRow(field,value);
}

QString RDAirplay_Hotkeys::stop_hotkey(int num) const
{
  QString field=QString().sprintf("Stop Line %d",num);
  return RDGetSqlValue("RDHOTKEYS",
                       "STATION_NAME",station_hotkeys,
                       "MODULE_NAME","airplay",
                       "KEY_LABEL",field,"KEY_VALUE").toString();
}

void RDAirplay_Hotkeys::setstop_hotkey(int num, QString value) const
{
  QString field=QString().sprintf("Stop Line %d",num);
  SetRow(field,value);
}

QString RDAirplay_Hotkeys::pause_hotkey(int num) const
{
  QString field=QString().sprintf("Pause Line %d",num);
  return RDGetSqlValue("RDHOTKEYS",
                       "STATION_NAME",station_hotkeys,
                       "MODULE_NAME","airplay",
                       "KEY_LABEL",field,"KEY_VALUE").toString();
}

void RDAirplay_Hotkeys::setpause_hotkey(int num, QString value) const
{
  QString field=QString().sprintf("Pause Line %d",num);
  SetRow(field,value);
}

QString RDAirplay_Hotkeys::add_hotkey() const
{ 
  return RDGetSqlValue("RDHOTKEYS",
                       "STATION_NAME",station_hotkeys,
                       "MODULE_NAME","airplay",
                       "KEY_LABEL","Add","KEY_VALUE").toString();
}

void RDAirplay_Hotkeys::setadd_hotkey(QString value) const
{
  SetRow("Add",value);
}


QString RDAirplay_Hotkeys::del_hotkey() const
{ 
  return RDGetSqlValue("RDHOTKEYS",
                       "STATION_NAME",station_hotkeys,
                       "MODULE_NAME","airplay",
                       "KEY_LABEL","Delete","KEY_VALUE").toString();
}

void RDAirplay_Hotkeys::setdel_hotkey(QString value) const
{
  SetRow("Delete",value);
}

QString RDAirplay_Hotkeys::copy_hotkey() const
{ 
  return RDGetSqlValue("RDHOTKEYS",
                       "STATION_NAME",station_hotkeys,
                       "MODULE_NAME","airplay",
                       "KEY_LABEL","Copy","KEY_VALUE").toString();
}

void RDAirplay_Hotkeys::setcopy_hotkey(QString value) const
{
  SetRow("Copy",value);
}

QString RDAirplay_Hotkeys::move_hotkey() const
{ 
  return RDGetSqlValue("RDHOTKEYS",
                       "STATION_NAME",station_hotkeys,
                       "MODULE_NAME","airplay",
                       "KEY_LABEL","Move","KEY_VALUE").toString();
}

void RDAirplay_Hotkeys::setmove_hotkey(QString value) const
{
  SetRow("Move",value);
}

QString RDAirplay_Hotkeys::soundpanel_hotkey() const
{ 
  return RDGetSqlValue("RDHOTKEYS",
                       "STATION_NAME",station_hotkeys,
                       "MODULE_NAME","airplay",
                       "KEY_LABEL","Sound Panel","KEY_VALUE").toString();
}

void RDAirplay_Hotkeys::setsoundpanel_hotkey(QString value) const
{
  SetRow("Sound Panel",value);
}

QString RDAirplay_Hotkeys::mainlog_hotkey() const
{ 
  return RDGetSqlValue("RDHOTKEYS",
                       "STATION_NAME",station_hotkeys,
                       "MODULE_NAME","airplay",
                       "KEY_LABEL","Main Log","KEY_VALUE").toString();
}

void RDAirplay_Hotkeys::setmainlog_hotkey(QString value) const
{
  SetRow("Main Log",value);
}

QString RDAirplay_Hotkeys::auxlog_hotkey(int num) const
{ 
  QString field=QString().sprintf("Aux Log %d",num);
  return RDGetSqlValue("RDHOTKEYS",
                       "STATION_NAME",station_hotkeys,
                       "MODULE_NAME","airplay",
                       "KEY_LABEL",field,"KEY_VALUE").toString();
}

void RDAirplay_Hotkeys::setauxlog_hotkey(int num, QString value) const
{
  QString field=QString().sprintf("Aux Log %d",num);
  SetRow(field,value);
}

void RDAirplay_Hotkeys::SetRow(const QString &param,QString value) const
{
  RDSqlQuery *q;
  QString sql;

  sql=QString().sprintf("UPDATE RDHOTKEYS SET KEY_VALUE=\"%s\" WHERE STATION_NAME=\"%s\" \
                         AND MODULE_NAME=\"airplay\" and KEY_LABEL = \"%s\"",
			(const char *)value,
			(const char *)RDEscapeString(station_hotkeys),
			(const char *)param);
  q=new RDSqlQuery(sql);
  delete q;
}

