// rdalsa.h
//
// Abstract an ALSA configuration. 
//
//   (C) Copyright 2009,2016 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef RDALSA_H
#define RDALSA_H

#include <vector>

#include <qstring.h>

#include <rd.h>

#define START_MARKER "# *** Start of Rivendell configuration generated by rdalsaconfig(1) ***"
#define END_MARKER "# *** End of Rivendell configuration generated by rdalsaconfig(1) ***"

class RDAlsa
{
 public:
  RDAlsa();
  unsigned cards() const;
  QString cardId(unsigned cardnum) const;
  QString cardDriver(unsigned cardnum) const;
  QString cardName(unsigned cardnum) const;
  QString cardLongName(unsigned cardnum) const;
  QString cardMixerName(unsigned cardnum) const;
  int pcmDevices(unsigned cardnum) const;
  QString pcmName(unsigned cardnum,unsigned pcm) const;
  int rivendellCard(int slot) const;
  void setRivendellCard(int slot,int cardnum);
  int rivendellDevice(int slot) const;
  void setRivendellDevice(int slot,int devnum);
  bool load(const QString &filename);
  bool save(const QString &filename);
  void clear();

 private:
  void LoadSystemConfig();
  bool LoadAsoundConfig(const QString &filename);
  bool SaveAsoundConfig(const QString &filename);
  std::vector<QString> card_ids;
  std::vector<QString> card_drivers;
  std::vector<QString> card_names;
  std::vector<QString> card_long_names;
  std::vector<QString> card_mixer_names;
  std::vector<std::vector<QString> > card_pcm_names;
  int card_rivendell_cards[RD_MAX_CARDS];
  int card_rivendell_devices[RD_MAX_CARDS];
  QStringList card_other_lines;
};


#endif  // RDALSA_H
