// import_audio.h
//
// Audio File Importation Dialog for Rivendell.
//
//   (C) Copyright 2002-2019 Fred Gleason <fredg@paravelsystems.com>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef IMPORT_AUDIO_H
#define IMPORT_AUDIO_H

#include <sys/types.h>
#include <unistd.h>

#include <q3buttongroup.h>

#include <qlabel.h>
#include <qlineedit.h>
#include <qtimer.h>
#include <qfile.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>

#include <rdaudioexport.h>
#include <rdaudioimport.h>
#include <rdbusybar.h>
#include <rdcut.h>
#include <rddialog.h>
#include <rdexport_settings_dialog.h>
#include <rdsettings.h>
#include <rdwavedata.h>

//
// Widget Settings
//
#define IMPORT_BAR_INTERVAL 500
#define IMPORT_TEMP_BASENAME "rdlib"

class RDImportAudio : public RDDialog
{
 Q_OBJECT
 public:
 RDImportAudio(QString cutname,QString *path,RDSettings *settings,
	       bool *import_metadata,RDWaveData *wavedata,
	       RDCut *clipboard,bool *running,QWidget *parent=0);
  ~RDImportAudio();
  QSize sizeHint() const;
  QSizePolicy sizePolicy() const;
  void enableAutotrim(bool state);
  void setAutotrimLevel(int lvl);
  void enableNormalization(bool state);
  void setNormalizationLevel(int lvl);
  void setChannels(int chans);

 public slots:
  int exec(bool enable_import,bool enable_export);

 private slots:
  void modeClickedData(int id);
  void filenameChangedData(const QString &str);
  void normalizeCheckData(bool state);
  void autotrimCheckData(bool state);
  void selectInputFileData();
  void selectOutputFileData();
  void selectOutputFormatData();
  void importData();
  void cancelData();

 protected:
  void paintEvent(QPaintEvent *e);
  void closeEvent(QCloseEvent *e);

 private:
  void Import();
  void Export();
  void StartBar();
  void StopBar();
  RDSettings *import_default_settings;
  RDCut *import_clipboard;
  bool *import_running;
  Q3ButtonGroup *import_mode_group;
  QRadioButton *import_importmode_button;
  QRadioButton *import_exportmode_button;
  QLabel *import_in_filename_label;
  QLineEdit *import_in_filename_edit;
  QCheckBox *import_in_metadata_box;
  QPushButton *import_in_selector_button;
  QLabel *import_channels_label;
  QLabel *import_out_filename_label;
  QLineEdit *import_out_filename_edit;
  QCheckBox *import_out_metadata_box;
  QPushButton *import_out_selector_button;
  QLabel *import_format_label;
  QLineEdit *import_format_edit;
  QPushButton *import_out_format_button;
  RDBusyBar *import_bar;
  QCheckBox *import_normalize_box;
  QSpinBox *import_normalize_spin;
  QLabel *import_normalize_label;
  QLabel *import_normalize_unit;
  QCheckBox *import_autotrim_box;
  QSpinBox *import_autotrim_spin;
  QLabel *import_autotrim_label;
  QLabel *import_autotrim_unit;
  QComboBox *import_channels_box;
  QPushButton *import_cancel_button;
  QPushButton *import_import_button;
  QString *import_path;
  QString import_file_filter;
  QString import_cutname;
  QString import_dest_filename;
  bool import_import_aborted;
  bool *import_import_metadata;
  RDSettings *import_settings;
  RDWaveData *import_wavedata;
  RDAudioImport *import_import_conv;
  RDAudioExport *import_export_conv;
};


#endif  // RDIMPORT_AUDIO_H
