// cmdswitch.cpp
//
// Process Command-Line Switches
//
//   (C) Copyright 2012 Fred Gleason <fredg@paravelsystems.com>
//       All Rights Reserved
//

#include <syslog.h>

#include <stdlib.h>
#include <stdio.h>

#include "cmdswitch.h"

CmdSwitch::CmdSwitch(int argc,char *argv[],const char *modname,
			 const char *usage)
{
  unsigned l=0;
  bool handled=false;
  bool debug=false;

  for(int i=1;i<argc;i++) {
#ifndef WIN32
    if(!strcmp(argv[i],"--version")) {
      printf("%s v%s\n",modname,VERSION);
      exit(0);
    }
#endif  // WIN32
    if(!strcmp(argv[i],"--help")) {
      printf("\n%s %s\n",modname,usage);
      exit(0);
    }
    if(!strcmp(argv[i],"-d")) {
      debug=true;
    }
    l=strlen(argv[i]);
    handled=false;
    for(unsigned j=0;j<l;j++) {
      if(argv[i][j]=='=') {
	switch_keys.push_back(QString(argv[i]).left(j));
	switch_values.push_back(QString(argv[i]).right(l-(j+1)));
	switch_processed.push_back(false);
	j=l;
	handled=true;
      }
    }
    if(!handled) {
      switch_keys.push_back(QString(argv[i]));
      switch_values.push_back(QString(""));
      switch_processed.push_back(false);
    }
  }

  //
  // Initialize Logging
  //
#ifndef WIN32
  if(debug) {
    openlog(modname,LOG_PERROR,LOG_USER);
  }
  else {
    openlog(modname,0,LOG_USER);
  }
#endif  // WIN32
}


unsigned CmdSwitch::keys() const
{
  return switch_keys.size();
}


QString CmdSwitch::key(unsigned n) const
{
  return switch_keys[n];
}


QString CmdSwitch::value(unsigned n) const
{
  return switch_values[n];
}


bool CmdSwitch::processed(unsigned n) const
{
  return switch_processed[n];
}


void CmdSwitch::setProcessed(unsigned n,bool state)
{
  switch_processed[n]=state;
}


bool CmdSwitch::allProcessed() const
{
  for(unsigned i=0;i<switch_processed.size();i++) {
    if(!switch_processed[i]) {
      return false;
    }
  }
  return true;
}
